/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoApproveAllowanceFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeecontext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        CryptoApproveAllowanceTransactionBody op = txnBody.cryptoApproveAllowanceOrThrow();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        int totalAllowances = op.cryptoAllowances().size() + op.tokenAllowances().size() + op.nftAllowances().size();
        if (totalAllowances > 0) {
            this.addExtraFee(feeResult, serviceDef, Extra.ALLOWANCES, feeSchedule, totalAllowances);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_APPROVE_ALLOWANCE;
    }
}

