/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class TokenUpdateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.TOKEN_UPDATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        TokenUpdateTransactionBody op = txnBody.tokenUpdateOrThrow();
        long keys = 0L;
        if (op.hasAdminKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.adminKey());
        }
        if (op.hasFeeScheduleKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.feeScheduleKey());
        }
        if (op.hasFreezeKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.freezeKey());
        }
        if (op.hasKycKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.kycKey());
        }
        if (op.hasMetadataKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.metadataKey());
        }
        if (op.hasPauseKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.pauseKey());
        }
        if (op.hasSupplyKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.supplyKey());
        }
        if (op.hasWipeKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.wipeKey());
        }
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.TOKEN_UPDATE;
    }
}

