/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees.util;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.spi.fees.Fees;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import org.hiero.hapi.fees.FeeResult;

public class FeeUtils {
    private FeeUtils() {
    }

    public static Fees feeResultToFees(FeeResult feeResult, ExchangeRate rate) {
        return new Fees(FeeUtils.tinycentsToTinybars(feeResult.getNodeTotalTinycents(), rate), FeeUtils.tinycentsToTinybars(feeResult.getNetworkTotalTinycents(), rate), FeeUtils.tinycentsToTinybars(feeResult.getServiceTotalTinycents(), rate));
    }

    public static long tinycentsToTinybars(long amount, ExchangeRate rate) {
        int hbarEquiv = rate.getHbarEquiv();
        if (CommonUtils.productWouldOverflow((long)amount, (long)hbarEquiv)) {
            return FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)amount);
        }
        return amount * (long)hbarEquiv / (long)rate.getCentEquiv();
    }
}

