/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.ActivationResult;
import io.helidon.service.registry.Activator;
import io.helidon.service.registry.Activators;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.ScopeNotActiveException;
import io.helidon.service.registry.ScopedRegistry;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceProvider;
import io.helidon.service.registry.ServiceRegistryException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

class ScopedRegistryImpl
implements ScopedRegistry {
    private static final System.Logger LOGGER = System.getLogger(ScopedRegistryImpl.class.getName());
    private final ReadWriteLock serviceProvidersLock = new ReentrantReadWriteLock();
    private final Map<ServiceInfo, Activator<?>> activators = new IdentityHashMap();
    private final TypeName scope;
    private final String id;
    private boolean active = false;

    ScopedRegistryImpl(CoreServiceRegistry registry, TypeName scope, String id, Map<ServiceDescriptor<?>, Object> initialBindings) {
        this.scope = scope;
        this.id = id;
        for (Map.Entry<ServiceDescriptor<?>, Object> entry : initialBindings.entrySet()) {
            ServiceDescriptor<?> key = entry.getKey();
            ServiceProvider provider = new ServiceProvider(registry, key);
            Object value = entry.getValue();
            Activator<Object> fixedService = Activators.create(provider, value);
            this.activators.put(key, fixedService);
        }
    }

    @Override
    public void activate() {
        this.active = true;
    }

    @Override
    public void deactivate() {
        try {
            this.serviceProvidersLock.writeLock().lock();
            if (!this.active) {
                return;
            }
            List<Activator<?>> toShutdown = this.activators.values().stream().filter(it -> it.phase().eligibleForDeactivation()).sorted(ScopedRegistryImpl.shutdownComparator()).toList();
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Activator<?> managedService : toShutdown) {
                try {
                    ActivationResult activationResult = managedService.deactivate();
                    if (!activationResult.failure() || !LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                    if (activationResult.error().isPresent()) {
                        LOGGER.log(System.Logger.Level.DEBUG, "[" + this.id + "] Failed to deactivate " + managedService.description(), activationResult.error().get());
                        exceptions.add(activationResult.error().get());
                        continue;
                    }
                    LOGGER.log(System.Logger.Level.DEBUG, "[" + this.id + "] Failed to deactivate " + managedService.description());
                    exceptions.add(new ServiceRegistryException("Failed to deactivate " + managedService.description() + ", no exception received."));
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "[" + this.id + "] Failed to deactivate service provider: " + String.valueOf(managedService), (Throwable)e);
                    }
                    exceptions.add(new ServiceRegistryException("Failed to deactivate " + managedService.description(), e));
                }
            }
            this.active = false;
            if (exceptions.isEmpty()) {
                return;
            }
            ServiceRegistryException failure = new ServiceRegistryException("Deactivation failed");
            exceptions.forEach(failure::addSuppressed);
            throw failure;
        }
        finally {
            this.serviceProvidersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Activator<T> activator(ServiceInfo descriptor, Supplier<Activator<T>> activatorSupplier) {
        try {
            this.serviceProvidersLock.readLock().lock();
            this.checkActive();
            Activator<?> activator = this.activators.get(descriptor);
            if (activator != null) {
                Activator<?> activator2 = activator;
                return activator2;
            }
        }
        finally {
            this.serviceProvidersLock.readLock().unlock();
        }
        try {
            this.serviceProvidersLock.writeLock().lock();
            this.checkActive();
            Activator activator = this.activators.computeIfAbsent(descriptor, desc -> (Activator)activatorSupplier.get());
            return activator;
        }
        finally {
            this.serviceProvidersLock.writeLock().unlock();
        }
    }

    private static Comparator<? super Activator<?>> shutdownComparator() {
        return Comparator.comparingDouble(it -> it.descriptor().runLevel().orElse(100.0)).reversed().thenComparing(it -> it.descriptor().weight());
    }

    private void checkActive() {
        if (!this.active) {
            throw new ScopeNotActiveException("Injection scope " + this.scope.fqName() + "[" + this.id + "] is not active.", this.scope);
        }
    }
}

