/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionGetRecordQuery;
import com.hedera.hapi.node.transaction.TransactionGetRecordResponse;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NetworkTransactionGetRecordHandler
extends PaidQueryHandler {
    @Inject
    public NetworkTransactionGetRecordHandler() {
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.transactionGetRecordOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        TransactionGetRecordResponse.Builder response = TransactionGetRecordResponse.newBuilder().header(header);
        return Response.newBuilder().transactionGetRecord(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionGetRecordQuery op = context.query().transactionGetRecordOrThrow();
        if (!op.hasTransactionID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_ID);
        }
        TransactionID txnId = op.transactionIDOrThrow();
        AccountID accountID = txnId.accountID();
        if (accountID == null || accountID.equals((Object)AccountID.DEFAULT)) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        RecordCache recordCache = context.recordCache();
        TransactionGetRecordQuery op = query.transactionGetRecordOrThrow();
        TransactionGetRecordResponse.Builder responseBuilder = TransactionGetRecordResponse.newBuilder();
        TransactionID transactionId = op.transactionIDOrThrow();
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        responseBuilder.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            TransactionID topLevelTxnId = transactionId.nonce() > 0 ? transactionId.copyBuilder().nonce(0).build() : transactionId;
            RecordCache.History history = recordCache.getHistory(topLevelTxnId);
            if (history == null || history.records().isEmpty()) {
                responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.RECORD_NOT_FOUND).build());
            } else if (transactionId == topLevelTxnId) {
                responseBuilder.transactionRecord(history.userTransactionRecord());
                if (op.includeDuplicates()) {
                    responseBuilder.duplicateTransactionRecords(history.duplicateRecords());
                }
                if (op.includeChildRecords()) {
                    List<TransactionRecord> sortedRecords = history.childRecords().stream().sorted(Comparator.comparingLong(a -> a.transactionIDOrThrow().nonce())).toList();
                    responseBuilder.childTransactionRecords(sortedRecords);
                }
            } else {
                Optional<TransactionRecord> maybeRecord = history.childRecords().stream().filter(record -> transactionId.equals((Object)record.transactionID())).findFirst();
                if (maybeRecord.isEmpty()) {
                    responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.RECORD_NOT_FOUND).build());
                } else {
                    responseBuilder.transactionRecord(maybeRecord.get());
                }
            }
        }
        return Response.newBuilder().transactionGetRecord(responseBuilder).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        RecordCache.History history;
        RecordCache recordCache = queryContext.recordCache();
        TransactionGetRecordQuery op = queryContext.query().transactionGetRecordOrThrow();
        ResponseType responseType = op.headerOrThrow().responseType();
        int stateProofSize = responseType == ResponseType.ANSWER_STATE_PROOF || responseType == ResponseType.COST_ANSWER_STATE_PROOF ? 2000 : 0;
        FeeComponents feeMatricesForTxNode = FeeComponents.newBuilder().setConstant(1L).setBpt(244L).setBpr(148L + (long)stateProofSize).build();
        FeeData perRecordFeeData = FeeData.newBuilder().setNetworkdata(FeeComponents.getDefaultInstance()).setNodedata(feeMatricesForTxNode).setServicedata(FeeComponents.getDefaultInstance()).build();
        int recordCount = 1;
        if ((op.includeDuplicates() || op.includeChildRecords()) && (history = recordCache.getHistory(op.transactionIDOrThrow())) != null) {
            recordCount += op.includeDuplicates() ? history.duplicateCount() : 0;
            recordCount += op.includeChildRecords() ? history.childRecords().size() : 0;
        }
        FeeData feeData = NetworkTransactionGetRecordHandler.multiplierOfUsages(perRecordFeeData, recordCount);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> feeData);
    }

    private static FeeData multiplierOfUsages(FeeData feeData, int multiplier) {
        return FeeData.newBuilder().setNodedata(NetworkTransactionGetRecordHandler.multiplierOfScopedUsages(feeData.getNodedata(), multiplier)).setNetworkdata(NetworkTransactionGetRecordHandler.multiplierOfScopedUsages(feeData.getNetworkdata(), multiplier)).setServicedata(NetworkTransactionGetRecordHandler.multiplierOfScopedUsages(feeData.getServicedata(), multiplier)).build();
    }

    private static FeeComponents multiplierOfScopedUsages(FeeComponents feeComponents, int multiplier) {
        return FeeComponents.newBuilder().setMin(feeComponents.getMin()).setMax(feeComponents.getMax()).setConstant(feeComponents.getConstant() * (long)multiplier).setBpt(feeComponents.getBpt() * (long)multiplier).setVpt(feeComponents.getVpt() * (long)multiplier).setRbh(feeComponents.getRbh() * (long)multiplier).setSbh(feeComponents.getSbh() * (long)multiplier).setGas(feeComponents.getGas() * (long)multiplier).setTv(feeComponents.getTv() * (long)multiplier).setBpr(feeComponents.getBpr() * (long)multiplier).setSbpr(feeComponents.getSbpr() * (long)multiplier).build();
    }
}

