/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.esaulpaugh.headlong.abi.Address;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.hapi.utils.ByteStringUtils;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.ScheduleID;
import com.hederahashgraph.api.proto.java.SignatureMap;
import com.hederahashgraph.api.proto.java.SignedTransaction;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.DigestType;

public final class CommonUtils {
    private CommonUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static String base64encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static ByteString extractTransactionBodyByteString(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        if (transaction.hasBody()) {
            return transaction.getBody().toByteString();
        }
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom((ByteString)signedTransactionBytes).getBodyBytes();
        }
        return transaction.getBodyBytes();
    }

    public static byte[] extractTransactionBodyBytes(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return ByteStringUtils.unwrapUnsafelyIfPossible(CommonUtils.extractTransactionBodyByteString(transaction));
    }

    public static com.hederahashgraph.api.proto.java.TransactionBody extractTransactionBodyUnchecked(TransactionOrBuilder transaction) {
        try {
            return com.hederahashgraph.api.proto.java.TransactionBody.parseFrom((ByteString)CommonUtils.extractTransactionBodyByteString(transaction));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static com.hederahashgraph.api.proto.java.TransactionBody extractTransactionBody(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return com.hederahashgraph.api.proto.java.TransactionBody.parseFrom((ByteString)CommonUtils.extractTransactionBodyByteString(transaction));
    }

    public static SignatureMap extractSignatureMap(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom((ByteString)signedTransactionBytes).getSigMap();
        }
        return transaction.getSigMap();
    }

    public static MessageDigest sha384DigestOrThrow() {
        try {
            return MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        }
        catch (NoSuchAlgorithmException fatal) {
            throw new IllegalStateException(fatal);
        }
    }

    public static Bytes noThrowSha384HashOf(@NonNull Bytes bytes) {
        MessageDigest digest = CommonUtils.sha384DigestOrThrow();
        return CommonUtils.hashOfAll(digest, bytes);
    }

    public static Bytes sha384HashOfAll(Bytes ... allBytes) {
        MessageDigest digest = CommonUtils.sha384DigestOrThrow();
        return CommonUtils.hashOfAll(digest, allBytes);
    }

    public static Bytes hashOfAll(@NonNull MessageDigest digest, Bytes ... allBytes) {
        Objects.requireNonNull(digest);
        Objects.requireNonNull(allBytes);
        for (Bytes bytes : allBytes) {
            bytes.writeTo(digest);
        }
        return Bytes.wrap((byte[])digest.digest());
    }

    public static byte[] noThrowSha384HashOf(byte[] byteArray) {
        Objects.requireNonNull(byteArray);
        MessageDigest digest = CommonUtils.sha384DigestOrThrow();
        return digest.digest(byteArray);
    }

    public static Bytes sha384HashOfAll(byte[] ... bytes) {
        return Bytes.wrap((byte[])CommonUtils.sha384HashOf(bytes));
    }

    public static byte[] sha384HashOf(byte[] ... bytes) {
        return CommonUtils.hashOfAll(CommonUtils.sha384DigestOrThrow(), bytes);
    }

    public static Bytes sha384HashOf(@NonNull Bytes first, @NonNull Bytes second, @NonNull byte[] third) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(third);
        MessageDigest digest = CommonUtils.sha384DigestOrThrow();
        first.writeTo(digest);
        second.writeTo(digest);
        return Bytes.wrap((byte[])digest.digest(third));
    }

    public static byte[] hashOfAll(@NonNull MessageDigest digest, byte[] ... bytes) {
        Objects.requireNonNull(digest);
        Objects.requireNonNull(bytes);
        for (byte[] member : bytes) {
            digest.update(member);
        }
        return digest.digest();
    }

    public static boolean productWouldOverflow(long multiplier, long multiplicand) {
        if (multiplicand == 0L) {
            return false;
        }
        long maxMultiplier = Long.MAX_VALUE / multiplicand;
        return multiplier > maxMultiplier;
    }

    @NonNull
    public static HederaFunctionality functionOf(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn) throws UnknownHederaFunctionality {
        Objects.requireNonNull(txn);
        return CommonPbjConverters.fromPbj(HapiUtils.functionOf((TransactionBody)CommonPbjConverters.toPbj(txn)));
    }

    public static byte[] asEvmAddress(long num) {
        byte[] evmAddress = new byte[20];
        System.arraycopy(Longs.toByteArray((long)num), 0, evmAddress, 12, 8);
        return evmAddress;
    }

    public static Instant timestampToInstant(com.hederahashgraph.api.proto.java.Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Instant pbjTimestampToInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.seconds(), timestamp.nanos());
    }

    public static ScheduleID asScheduleId(long shard, long realm, @NonNull Address address) {
        return ScheduleID.newBuilder().setShardNum(shard).setRealmNum(realm).setScheduleNum(address.value().longValueExact()).build();
    }

    public static long clampedAdd(long addendA, long addendB) {
        try {
            return Math.addExact(addendA, addendB);
        }
        catch (ArithmeticException ae) {
            return addendA > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public static long clampedMultiply(long a, long b) {
        try {
            return Math.multiplyExact(a, b);
        }
        catch (ArithmeticException ignore) {
            return Long.signum(a) == Long.signum(b) ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public static Bytes inputOrNullHash(@Nullable Bytes maybeHash) {
        return maybeHash != null && maybeHash.length() > 0L ? maybeHash : Cryptography.NULL_HASH.getBytes();
    }
}

