/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.forensics;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.exports.recordstreaming.RecordStreamingUtils;
import com.hedera.node.app.hapi.utils.forensics.RecordStreamEntry;
import com.hedera.node.app.hapi.utils.forensics.TransactionParts;
import com.hedera.services.stream.proto.SidecarFile;
import com.hedera.services.stream.proto.TransactionSidecarRecord;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class RecordParsers {
    private RecordParsers() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static List<RecordStreamEntry> parseV6RecordStreamEntriesIn(String streamDir) throws IOException {
        return RecordParsers.parseV6RecordStreamEntriesIn(streamDir, f -> true);
    }

    public static List<RecordStreamEntry> parseV6RecordStreamEntriesIn(String streamDir, Predicate<String> inclusionTest) throws IOException {
        Path authorizedDir = Path.of(streamDir, new String[0]);
        List<String> recordFiles = RecordStreamingUtils.orderedRecordFilesFrom(streamDir, inclusionTest);
        ArrayList<RecordStreamEntry> entries = new ArrayList<RecordStreamEntry>();
        for (String recordFile : recordFiles) {
            ((Optional)RecordStreamingUtils.readMaybeCompressedRecordStreamFile(authorizedDir, recordFile).getValue()).ifPresent(records -> records.getRecordStreamItemsList().forEach(item -> {
                TransactionRecord itemRecord = item.getRecord();
                entries.add(new RecordStreamEntry(TransactionParts.from(item.getTransaction()), itemRecord, CommonUtils.timestampToInstant(itemRecord.getConsensusTimestamp())));
            }));
        }
        return entries;
    }

    public static Map<Instant, List<TransactionSidecarRecord>> parseV6SidecarRecordsByConsTimeIn(String streamDir) throws IOException {
        Path authorizedDir = Path.of(streamDir, new String[0]);
        List<String> sidecarFiles = RecordStreamingUtils.orderedSidecarFilesFrom(streamDir);
        HashMap<Instant, List<TransactionSidecarRecord>> sidecarRecords = new HashMap<Instant, List<TransactionSidecarRecord>>();
        for (String sidecarFile : sidecarFiles) {
            SidecarFile data = RecordStreamingUtils.readSidecarFile(authorizedDir, sidecarFile);
            data.getSidecarRecordsList().forEach(sidecarRecord -> sidecarRecords.computeIfAbsent(CommonUtils.timestampToInstant(sidecarRecord.getConsensusTimestamp()), ignore -> new ArrayList()).add(sidecarRecord));
        }
        return sidecarRecords;
    }

    public static void visitWithSidecars(List<RecordStreamEntry> entries, Map<Instant, List<TransactionSidecarRecord>> sidecarRecords, BiConsumer<RecordStreamEntry, List<TransactionSidecarRecord>> observer) {
        entries.forEach(entry -> observer.accept((RecordStreamEntry)entry, sidecarRecords.getOrDefault(entry.consensusTime(), Collections.emptyList())));
    }
}

