/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication;

import com.swirlds.base.time.Time;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.ConnectionManager;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.NetworkUtils;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationProtocols;
import org.hiero.consensus.gossip.impl.network.communication.Negotiator;
import org.hiero.consensus.gossip.impl.network.protocol.ProtocolRunnable;

public class ProtocolNegotiatorThread
implements InterruptableRunnable {
    private static final Duration SOCKET_EXCEPTION_DURATION = Duration.ofMinutes(1L);
    private final int sleepMillis;
    private final ConnectionManager connectionManager;
    private final List<ProtocolRunnable> handshakeProtocols;
    private final NegotiationProtocols protocols;
    private final RateLimiter socketExceptionRateLimiter;

    public ProtocolNegotiatorThread(ConnectionManager connectionManager, int sleepMillis, List<ProtocolRunnable> handshakeProtocols, NegotiationProtocols protocols, Time time) {
        this.connectionManager = connectionManager;
        this.sleepMillis = sleepMillis;
        this.handshakeProtocols = handshakeProtocols;
        this.protocols = protocols;
        this.socketExceptionRateLimiter = new RateLimiter(time, SOCKET_EXCEPTION_DURATION);
    }

    public void run() throws InterruptedException {
        Connection currentConn = this.connectionManager.waitForConnection();
        Negotiator negotiator = new Negotiator(this.protocols, currentConn, this.sleepMillis);
        try {
            for (ProtocolRunnable handshakeProtocol : this.handshakeProtocols) {
                handshakeProtocol.runProtocol(currentConn);
            }
            while (currentConn.connected()) {
                negotiator.execute();
            }
        }
        catch (IOException | RuntimeException | NetworkProtocolException | NegotiationException e) {
            NetworkUtils.handleNetworkException(e, currentConn, this.socketExceptionRateLimiter);
        }
    }
}

