/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication.states;

import java.io.IOException;
import java.io.OutputStream;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationProtocols;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationState;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationStateWithDescription;
import org.hiero.consensus.gossip.impl.network.communication.states.ProtocolNegotiated;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;

public class ReceivedInitiate
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final OutputStream byteOutput;
    private final ProtocolNegotiated stateNegotiated;
    private final NegotiationState sleep;
    private int protocolInitiated = Integer.MIN_VALUE;

    public ReceivedInitiate(NegotiationProtocols protocols, OutputStream byteOutput, ProtocolNegotiated stateNegotiated, NegotiationState sleep) {
        this.protocols = protocols;
        this.byteOutput = byteOutput;
        this.stateNegotiated = stateNegotiated;
        this.sleep = sleep;
    }

    public NegotiationState receivedInitiate(int protocolId) {
        this.protocolInitiated = protocolId;
        return this;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, InterruptedException, IOException {
        PeerProtocol peerProtocol = this.protocols.getProtocol(this.protocolInitiated);
        if (peerProtocol.shouldAccept()) {
            try {
                this.byteOutput.write(254);
                this.byteOutput.flush();
            }
            catch (IOException ex) {
                peerProtocol.acceptFailed();
                throw ex;
            }
            this.stateNegotiated.runProtocol(peerProtocol);
            this.protocolInitiated = Integer.MIN_VALUE;
            this.setDescription("accepted protocol initiated by peer - " + peerProtocol.getProtocolName());
            return this.stateNegotiated;
        }
        this.byteOutput.write(253);
        this.byteOutput.flush();
        this.protocolInitiated = Integer.MIN_VALUE;
        this.setDescription("rejected protocol initiated by peer - " + peerProtocol.getProtocolName());
        return this.sleep;
    }
}

