/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.app.fees.schemas.V0490FeeSchema;
import com.hedera.node.config.data.BootstrapConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class FeeService
implements Service {
    public static final String NAME = "FeeService";

    @NonNull
    public String getServiceName() {
        return NAME;
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.register((Schema)new V0490FeeSchema());
    }

    public boolean doGenesisSetup(@NonNull WritableStates writableStates, @NonNull Configuration configuration) {
        Objects.requireNonNull(writableStates);
        BootstrapConfig bootstrapConfig = (BootstrapConfig)configuration.getConfigData(BootstrapConfig.class);
        ExchangeRateSet exchangeRateSet = ExchangeRateSet.newBuilder().currentRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesCurrentCentEquiv()).hbarEquiv(bootstrapConfig.ratesCurrentHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesCurrentExpiry())).build()).nextRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesNextCentEquiv()).hbarEquiv(bootstrapConfig.ratesNextHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesNextExpiry())).build()).build();
        writableStates.getSingleton(V0490FeeSchema.MIDNIGHT_RATES_STATE_ID).put((Object)exchangeRateSet);
        return true;
    }
}

