/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.listeners;

import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.networkadmin.ReadableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.handlers.ReadableFreezeUpgradeActions;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.config.ConfigProvider;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteListener;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteNotification;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class WriteStateToDiskListener
implements StateWriteToDiskCompleteListener {
    private static final Logger log = LogManager.getLogger(WriteStateToDiskListener.class);
    private final Supplier<AutoCloseableWrapper<State>> stateAccessor;
    private final Executor executor;
    private final ConfigProvider configProvider;
    private final StartupNetworks startupNetworks;
    private final EntityIdFactory entityIdFactory;
    private final BlockBufferService blockBufferService;

    @Inject
    public WriteStateToDiskListener(@NonNull Supplier<AutoCloseableWrapper<State>> stateAccessor, @Named(value="FreezeService") @NonNull Executor executor, @NonNull ConfigProvider configProvider, @NonNull StartupNetworks startupNetworks, @NonNull EntityIdFactory entityIdFactory, @NonNull BlockBufferService blockBufferService) {
        this.stateAccessor = Objects.requireNonNull(stateAccessor);
        this.executor = Objects.requireNonNull(executor);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.startupNetworks = Objects.requireNonNull(startupNetworks);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
        this.blockBufferService = Objects.requireNonNull(blockBufferService);
    }

    public void notify(@NonNull StateWriteToDiskCompleteNotification notification) {
        try {
            this.blockBufferService.persistBuffer();
        }
        catch (Exception e) {
            log.error("Error while writing block buffer to disk", (Throwable)e);
        }
        if (notification.isFreezeState()) {
            log.info("StateWriteToDiskCompleteNotification Received : Freeze State Finished. consensusTimestamp: {}, roundNumber: {}, sequence: {}", (Object)notification.getConsensusTimestamp(), (Object)notification.getRoundNumber(), (Object)notification.getSequence());
            try (AutoCloseableWrapper<State> wrappedState = this.stateAccessor.get();){
                ReadableStoreFactoryImpl readableStoreFactory = new ReadableStoreFactoryImpl((State)wrappedState.get());
                ReadableFreezeStore readableFreezeStore = readableStoreFactory.readableStore(ReadableFreezeStore.class);
                ReadableUpgradeFileStore readableUpgradeFileStore = readableStoreFactory.readableStore(ReadableUpgradeFileStore.class);
                ReadableNodeStore readableNodeStore = readableStoreFactory.readableStore(ReadableNodeStore.class);
                ReadableStakingInfoStore readableStakingInfoStore = readableStoreFactory.readableStore(ReadableStakingInfoStore.class);
                ReadableFreezeUpgradeActions upgradeActions = new ReadableFreezeUpgradeActions((Configuration)this.configProvider.getConfiguration(), readableFreezeStore, this.executor, readableUpgradeFileStore, readableNodeStore, readableStakingInfoStore, this.entityIdFactory);
                log.info("Externalizing freeze if upgrade is pending");
                upgradeActions.externalizeFreezeIfUpgradePending();
            }
            catch (Exception e) {
                log.error("Error while responding to freeze state notification", (Throwable)e);
            }
        }
        if (notification.getRoundNumber() > 0L) {
            this.startupNetworks.archiveStartupNetworks();
        }
    }
}

