/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.services.MigrationContextImpl;
import com.hedera.node.app.services.MigrationStateChanges;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.app.state.merkle.SchemaApplicationType;
import com.hedera.node.app.state.merkle.SchemaApplications;
import com.hedera.node.app.state.merkle.VersionUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.VirtualMapStateImpl;
import com.swirlds.state.spi.FilteredReadableStates;
import com.swirlds.state.spi.FilteredWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.consensus.platformstate.PlatformStateUtils;

public class MerkleSchemaRegistry
implements SchemaRegistry<SemanticVersion> {
    private static final Logger logger = LogManager.getLogger(MerkleSchemaRegistry.class);
    private final String serviceName;
    private final SortedSet<Schema<SemanticVersion>> schemas = new TreeSet<Schema<SemanticVersion>>();
    private final SchemaApplications schemaApplications;

    public MerkleSchemaRegistry(@NonNull String serviceName, @NonNull SchemaApplications schemaApplications) {
        this.serviceName = StateMetadata.validateServiceName((String)Objects.requireNonNull(serviceName));
        this.schemaApplications = Objects.requireNonNull(schemaApplications);
    }

    public SchemaRegistry register(@NonNull Schema<SemanticVersion> schema) {
        this.schemas.remove(schema);
        this.schemas.add(Objects.requireNonNull(schema));
        logger.debug("Registering schema {} for service {} ", new Supplier[]{() -> HapiUtils.toString((SemanticVersion)((SemanticVersion)schema.getVersion())), () -> this.serviceName});
        return this;
    }

    public void migrate(@NonNull State state, @Nullable SemanticVersion previousVersion, @NonNull SemanticVersion currentVersion, @NonNull Configuration appConfig, @NonNull Configuration platformConfig, @NonNull Map<String, Object> sharedValues, @NonNull MigrationStateChanges migrationStateChanges, @NonNull StartupNetworks startupNetworks, @NonNull InitTrigger trigger) {
        long roundNumber;
        Objects.requireNonNull(state);
        Objects.requireNonNull(currentVersion);
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(platformConfig);
        Objects.requireNonNull(sharedValues);
        Objects.requireNonNull(migrationStateChanges);
        Objects.requireNonNull(startupNetworks);
        Objects.requireNonNull(trigger);
        if (VersionUtils.isSoOrdered(currentVersion, previousVersion)) {
            throw new IllegalArgumentException("The currentVersion must be at least the previousVersion");
        }
        long l = roundNumber = trigger == InitTrigger.GENESIS ? 0L : PlatformStateUtils.roundOf((State)state);
        if (this.schemas.isEmpty()) {
            logger.info("Service {} does not use state", (Object)this.serviceName);
            return;
        }
        SemanticVersion latestVersion = (SemanticVersion)this.schemas.getLast().getVersion();
        Supplier[] supplierArray = new Supplier[5];
        supplierArray[0] = this.schemas::size;
        supplierArray[1] = () -> this.serviceName;
        supplierArray[2] = () -> HapiUtils.toString((SemanticVersion)previousVersion);
        supplierArray[3] = () -> HapiUtils.toString((SemanticVersion)currentVersion);
        supplierArray[4] = () -> HapiUtils.toString((SemanticVersion)latestVersion);
        logger.info("Applying {} schemas for service {} with state version {}, software version {}, and latest service schema version {}", supplierArray);
        for (Schema schema : this.schemas) {
            WritableStates newStates;
            WritableStates writableStates;
            Set<SchemaApplicationType> applications = this.schemaApplications.computeApplications(previousVersion, latestVersion, (Schema<SemanticVersion>)schema, appConfig);
            logger.info("Applying {} schema {} ({})", (Object)this.serviceName, schema.getVersion(), applications);
            ReadableStates readableStates = state.getReadableStates(this.serviceName);
            FilteredReadableStates previousStates = new FilteredReadableStates(readableStates, readableStates.stateIds());
            if (applications.contains((Object)SchemaApplicationType.STATE_DEFINITIONS)) {
                List<Schema<SemanticVersion>> schemasAlreadyInState = this.schemas.tailSet((Schema<SemanticVersion>)schema).stream().filter(s -> s != schema && previousVersion != null && VersionUtils.alreadyIncludesStateDefs(previousVersion, (SemanticVersion)s.getVersion())).toList();
                RedefinedWritableStates redefinedWritableStates = this.applyStateDefinitions((Schema<SemanticVersion>)schema, schemasAlreadyInState, appConfig, state);
                writableStates = redefinedWritableStates.beforeStates();
                newStates = redefinedWritableStates.afterStates();
            } else {
                newStates = writableStates = state.getWritableStates(this.serviceName);
            }
            MigrationContextImpl migrationContext = new MigrationContextImpl((ReadableStates)previousStates, newStates, appConfig, platformConfig, previousVersion, roundNumber, sharedValues, startupNetworks);
            if (applications.contains((Object)SchemaApplicationType.MIGRATION)) {
                schema.migrate((MigrationContext)migrationContext);
            }
            if (applications.contains((Object)SchemaApplicationType.RESTART)) {
                schema.restart((MigrationContext)migrationContext);
            }
            if (writableStates instanceof VirtualMapStateImpl.MerkleWritableStates) {
                VirtualMapStateImpl.MerkleWritableStates mws = (VirtualMapStateImpl.MerkleWritableStates)writableStates;
                mws.commit();
                migrationStateChanges.trackCommit();
            }
            schema.statesToRemove().forEach(stateId -> state.removeServiceState(this.serviceName, stateId.intValue()));
        }
    }

    private RedefinedWritableStates applyStateDefinitions(@NonNull Schema<SemanticVersion> schema, @NonNull List<Schema<SemanticVersion>> schemasAlreadyInState, @NonNull Configuration nodeConfiguration, @NonNull State state) {
        schema.statesToCreate(nodeConfiguration).stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            String stateKey = def.stateKey();
            int stateId = def.stateId();
            if (schemasAlreadyInState.stream().anyMatch(s -> s.statesToRemove().contains(stateId))) {
                logger.info("  Skipping {} as it is removed by a later schema", (Object)stateKey);
                return;
            }
            logger.info("  Ensuring {} has state {}", (Object)this.serviceName, (Object)stateKey);
            StateMetadata md = new StateMetadata(this.serviceName, def);
            state.initializeState(md);
        });
        Set statesToRemove = schema.statesToRemove();
        WritableStates writableStates = state.getWritableStates(this.serviceName);
        HashSet remainingStates = new HashSet(writableStates.stateIds());
        remainingStates.removeAll(statesToRemove);
        logger.info("  Removing states {} from service {}", (Object)statesToRemove, (Object)this.serviceName);
        FilteredWritableStates newStates = new FilteredWritableStates(writableStates, remainingStates);
        return new RedefinedWritableStates(writableStates, (WritableStates)newStates);
    }

    private record RedefinedWritableStates(WritableStates beforeStates, WritableStates afterStates) {
    }
}

