/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import edu.umd.cs.findbugs.annotations.NonNull;

public record TipsetAdvancementWeight(long advancementWeight, long zeroWeightAdvancementCount) implements Comparable<TipsetAdvancementWeight>
{
    public static final TipsetAdvancementWeight ZERO_ADVANCEMENT_WEIGHT = TipsetAdvancementWeight.of(0L, 0L);

    public static TipsetAdvancementWeight of(long advancementWeight, long zeroWeightAdvancementCount) {
        return new TipsetAdvancementWeight(advancementWeight, zeroWeightAdvancementCount);
    }

    @NonNull
    public TipsetAdvancementWeight minus(@NonNull TipsetAdvancementWeight that) {
        return new TipsetAdvancementWeight(this.advancementWeight - that.advancementWeight, this.zeroWeightAdvancementCount - that.zeroWeightAdvancementCount);
    }

    @NonNull
    public TipsetAdvancementWeight plus(@NonNull TipsetAdvancementWeight that) {
        return new TipsetAdvancementWeight(this.advancementWeight + that.advancementWeight, this.zeroWeightAdvancementCount + that.zeroWeightAdvancementCount);
    }

    public boolean isGreaterThan(@NonNull TipsetAdvancementWeight that) {
        return this.compareTo(that) > 0;
    }

    public boolean isNonZero() {
        return this.advancementWeight != 0L || this.zeroWeightAdvancementCount != 0L;
    }

    @Override
    public int compareTo(TipsetAdvancementWeight o) {
        if (this.advancementWeight == o.advancementWeight) {
            return Double.compare(this.zeroWeightAdvancementCount, o.zeroWeightAdvancementCount);
        }
        return Double.compare(this.advancementWeight, o.advancementWeight);
    }
}

