/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.file.FileMetadata;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.FileStore;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableFileStoreImpl
extends FileStore
implements ReadableFileStore {
    private final ReadableKVState<FileID, File> fileState;
    private final ReadableEntityCounters entityCounters;

    public ReadableFileStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        this.fileState = Objects.requireNonNull(states.get(V0490FileSchema.FILES_STATE_ID));
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    @Nullable
    public FileMetadata getFileMetadata(@NonNull FileID id) {
        File file = this.getFileLeaf(id);
        return file == null ? null : FileStore.fileMetaFrom(file);
    }

    @Nullable
    public File getFileLeaf(@NonNull FileID id) {
        return (File)this.fileState.get((Object)id);
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.FILE);
    }
}

