/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.Weights;
import io.helidon.http.DirectHandler;
import io.helidon.http.HttpException;
import io.helidon.http.HttpPrologue;
import io.helidon.http.NotFoundException;
import io.helidon.http.RequestException;
import io.helidon.http.Status;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ServerLifecycle;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.ErrorHandlers;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.Filters;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRoutingFeature;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RouteCrawler;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServiceRoute;
import io.helidon.webserver.http.ServiceRules;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

final class HttpRoutingImpl
implements HttpRouting {
    private static final System.Logger LOGGER = System.getLogger(HttpRoutingImpl.class.getName());
    private static final HttpRoutingImpl EMPTY = HttpRoutingImpl.builder().build();
    private final Filters filters;
    private final ServiceRoute rootRoute;
    private final List<HttpFeature> features;
    private final int maxReRouteCount;
    private final HttpSecurity security;

    HttpRoutingImpl(RealBuilder builder) {
        ErrorHandlers errorHandlers = ErrorHandlers.create(builder.errorHandlers);
        this.filters = Filters.create(errorHandlers, List.copyOf(builder.filters));
        this.rootRoute = builder.rootRules.build();
        this.features = List.copyOf(builder.features);
        this.maxReRouteCount = builder.maxReRouteCount;
        this.security = builder.security;
    }

    static BuilderImpl builder() {
        return new BuilderImpl();
    }

    static HttpRoutingImpl empty() {
        return EMPTY;
    }

    @Override
    public void route(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) {
        RoutingExecutor routingExecutor = new RoutingExecutor(ctx, this.rootRoute, request, response, this.maxReRouteCount);
        this.filters.filter(ctx, request, response, routingExecutor);
    }

    @Override
    public void beforeStart() {
        this.filters.beforeStart();
        this.rootRoute.beforeStart();
        this.features.forEach(ServerLifecycle::beforeStart);
    }

    @Override
    public void afterStart(WebServer webServer) {
        this.filters.afterStart(webServer);
        this.rootRoute.afterStart(webServer);
        this.features.forEach(f -> f.afterStart(webServer));
    }

    @Override
    public void afterStop() {
        this.filters.afterStop();
        this.rootRoute.afterStop();
        this.features.forEach(ServerLifecycle::afterStop);
    }

    @Override
    public HttpSecurity security() {
        return this.security;
    }

    private static final class RealBuilder
    implements HttpRouting.Builder {
        private final List<Filter> filters = new ArrayList<Filter>();
        private final Map<Class<? extends Throwable>, ErrorHandler<?>> errorHandlers = new IdentityHashMap();
        private final ServiceRules rootRules = new ServiceRules();
        private final List<HttpFeature> features;
        private HttpSecurity security;
        private int maxReRouteCount;

        private RealBuilder(List<HttpFeature> features, HttpSecurity security, int maxReRouteCount) {
            this.features = new ArrayList<HttpFeature>(features);
            this.security = security;
            this.maxReRouteCount = maxReRouteCount;
        }

        public HttpRouting build() {
            throw new UnsupportedOperationException("This builder is internal and never built");
        }

        @Override
        public HttpRouting.Builder register(HttpService ... service) {
            this.rootRules.register(service);
            return this;
        }

        @Override
        public HttpRouting.Builder register(String pathPattern, HttpService ... service) {
            this.rootRules.register(pathPattern, service);
            return this;
        }

        @Override
        public HttpRouting.Builder route(HttpRoute route) {
            this.rootRules.route(route);
            return this;
        }

        @Override
        public HttpRouting.Builder addFilter(Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public HttpRouting.Builder addFeature(Supplier<? extends HttpFeature> feature) {
            HttpFeature it = feature.get();
            this.features.add(it);
            it.setup(this);
            return this;
        }

        @Override
        public <T extends Throwable> HttpRouting.Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.errorHandlers.put(exceptionClass, handler);
            return this;
        }

        @Override
        public HttpRouting.Builder maxReRouteCount(int maxReRouteCount) {
            this.maxReRouteCount = maxReRouteCount;
            return this;
        }

        @Override
        public HttpRouting.Builder security(HttpSecurity security) {
            this.security = security;
            return this;
        }

        @Override
        public HttpRouting.Builder copy() {
            throw new UnsupportedOperationException("This builder should only be used internally by Helidon and never copied");
        }
    }

    private static class BuilderImpl
    implements HttpRouting.Builder {
        private final List<HttpFeature> features = new ArrayList<HttpFeature>();
        private final HttpRoutingFeature mainRouting = new HttpRoutingFeature();
        private HttpSecurity security = HttpSecurity.create();
        private int maxReRouteCount = 10;

        private BuilderImpl() {
        }

        private BuilderImpl(List<HttpFeature> features, HttpRoutingFeature mainRouting, HttpSecurity security, int maxReroute) {
            this.features.addAll(features);
            this.mainRouting.copyFrom(mainRouting);
            this.security = security;
            this.maxReRouteCount = maxReroute;
        }

        public HttpRoutingImpl build() {
            this.features.add(this.mainRouting);
            Weights.sort(this.features);
            RealBuilder realBuilder = new RealBuilder(this.features, this.security, this.maxReRouteCount);
            for (HttpFeature feature : this.features) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Setting up feature: " + feature.getClass().getName());
                }
                feature.setup(realBuilder);
            }
            return new HttpRoutingImpl(realBuilder);
        }

        @Override
        public HttpRouting.Builder register(HttpService ... service) {
            this.mainRouting.service(service);
            return this;
        }

        @Override
        public HttpRouting.Builder register(String path, HttpService ... service) {
            this.mainRouting.service(path, service);
            return this;
        }

        @Override
        public HttpRouting.Builder route(HttpRoute route) {
            this.mainRouting.route(route);
            return this;
        }

        @Override
        public HttpRouting.Builder addFilter(Filter filter) {
            this.mainRouting.filter(filter);
            return this;
        }

        @Override
        public HttpRouting.Builder addFeature(Supplier<? extends HttpFeature> feature) {
            HttpFeature httpFeature = feature.get();
            this.features.add(httpFeature);
            return this;
        }

        @Override
        public <T extends Throwable> HttpRouting.Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.mainRouting.error(exceptionClass, handler);
            return this;
        }

        @Override
        public HttpRouting.Builder maxReRouteCount(int maxReRouteCount) {
            this.maxReRouteCount = maxReRouteCount;
            return this;
        }

        @Override
        public HttpRouting.Builder security(HttpSecurity security) {
            this.security = security;
            return this;
        }

        @Override
        public HttpRouting.Builder copy() {
            return new BuilderImpl(this.features, this.mainRouting, this.security, this.maxReRouteCount);
        }
    }

    private static final class RoutingExecutor
    implements Callable<Void> {
        private final ConnectionContext ctx;
        private final RoutingRequest request;
        private final RoutingResponse response;
        private final ServiceRoute rootRoute;
        private final int maxReRouteCount;

        private RoutingExecutor(ConnectionContext ctx, ServiceRoute rootRoute, RoutingRequest request, RoutingResponse response, int maxReRouteCount) {
            this.ctx = ctx;
            this.rootRoute = rootRoute;
            this.request = request;
            this.response = response;
            this.maxReRouteCount = maxReRouteCount;
        }

        @Override
        public Void call() throws Exception {
            RoutingResult result = this.doRoute(this.ctx, this.request, this.response);
            if (result == RoutingResult.FINISH) {
                this.response.commit();
                return null;
            }
            if (result == RoutingResult.NONE) {
                throw new NotFoundException("Endpoint not found");
            }
            int counter = 1;
            while (result == RoutingResult.ROUTE) {
                if (++counter == this.maxReRouteCount) {
                    LOGGER.log(System.Logger.Level.ERROR, "Rerouted more than " + this.maxReRouteCount + " times. Will not attempt further routing");
                    throw new HttpException("Too many reroutes", Status.INTERNAL_SERVER_ERROR_500, true);
                }
                result = this.doRoute(this.ctx, this.request, this.response);
            }
            if (result == RoutingResult.FINISH) {
                this.response.commit();
                return null;
            }
            throw new NotFoundException("Endpoint not found");
        }

        private RoutingResult doRoute(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) throws Exception {
            HttpPrologue prologue = request.prologue();
            RouteCrawler crawler = this.rootRoute.crawler(ctx, request);
            while (crawler.hasNext()) {
                response.resetRouting();
                RouteCrawler.CrawlerItem next = crawler.next();
                request.path(next.path());
                request.matchingPattern(next.matchingElement());
                next.handler().handle(request, response);
                if (response.shouldReroute()) {
                    if (response.isSent()) {
                        LOGGER.log(System.Logger.Level.WARNING, "Request to " + String.valueOf(request.prologue()) + " in inconsistent state. Request to re-route, but response was already sent. Ignoring reroute.");
                        return RoutingResult.FINISH;
                    }
                    HttpPrologue newPrologue = response.reroutePrologue(prologue);
                    request.prologue(newPrologue);
                    response.resetRouting();
                    return RoutingResult.ROUTE;
                }
                if (response.isNexted()) {
                    if (!response.isSent()) continue;
                    LOGGER.log(System.Logger.Level.WARNING, "Request to " + String.valueOf(request.prologue()) + " in inconsistent state. Request to next, but response was already sent. Ignoring next().");
                    return RoutingResult.FINISH;
                }
                if (response.hasEntity()) {
                    return RoutingResult.FINISH;
                }
                LOGGER.log(System.Logger.Level.WARNING, "A route MUST call either send, reroute, or next on ServerResponse on the request thread. Neither of these was called for request: " + String.valueOf(request.prologue()) + "; Handler: " + String.valueOf(next.handler()));
                throw RequestException.builder().message("Internal Server Error").type(DirectHandler.EventType.INTERNAL_ERROR).build();
            }
            return RoutingResult.NONE;
        }
    }

    private static enum RoutingResult {
        ROUTE,
        FINISH,
        NONE;

    }
}

