/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.sync;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.io.extendable.ExtendableOutputStream;
import org.hiero.consensus.io.extendable.OutputStreamExtension;
import org.hiero.consensus.io.extendable.extensions.CountingStreamExtension;

public class SyncOutputStream
extends SerializableDataOutputStream {
    private final CountingStreamExtension syncByteCounter;
    private final CountingStreamExtension connectionByteCounter;
    private final AtomicReference<Instant> requestSent;

    protected SyncOutputStream(OutputStream out, CountingStreamExtension syncByteCounter, CountingStreamExtension connectionByteCounter) {
        super(out);
        this.syncByteCounter = syncByteCounter;
        this.connectionByteCounter = connectionByteCounter;
        this.requestSent = new AtomicReference<Object>(null);
    }

    public static SyncOutputStream createSyncOutputStream(@NonNull Configuration configuration, @NonNull OutputStream out, int bufferSize) {
        CountingStreamExtension syncByteCounter = new CountingStreamExtension();
        CountingStreamExtension connectionByteCounter = new CountingStreamExtension();
        boolean compress = ((SocketConfig)configuration.getConfigData(SocketConfig.class)).gzipCompression();
        OutputStream meteredStream = ExtendableOutputStream.extendOutputStream((OutputStream)out, (OutputStreamExtension[])new OutputStreamExtension[]{connectionByteCounter});
        FilterOutputStream wrappedStream = compress ? new DeflaterOutputStream(meteredStream, new Deflater(-1, true), bufferSize, true) : new BufferedOutputStream(meteredStream, bufferSize);
        return new SyncOutputStream(wrappedStream, syncByteCounter, connectionByteCounter);
    }

    public CountingStreamExtension getSyncByteCounter() {
        return this.syncByteCounter;
    }

    public CountingStreamExtension getConnectionByteCounter() {
        return this.connectionByteCounter;
    }

    public void writeTipHashes(List<Hash> tipHashes) throws IOException {
        this.writeSerializableList(tipHashes, false, true);
    }
}

