/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.Pair;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.RecordAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.concurrent.interrupt.InterruptableConsumer;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.ThreadManager;

public final class VirtualMapMigration {
    private static final int QUEUE_CAPACITY = 10000;
    private static final String COMPONENT_NAME = "virtual-map-migration";

    private VirtualMapMigration() {
    }

    public static void extractVirtualMapData(ThreadManager threadManager, VirtualMap source, InterruptableConsumer<Pair<Bytes, Bytes>> handler, int threadCount) throws InterruptedException {
        int index;
        long firstLeafPath = source.getMetadata().getFirstLeafPath();
        long lastLeafPath = source.getMetadata().getLastLeafPath();
        if (firstLeafPath == -1L || lastLeafPath == -1L) {
            return;
        }
        RecordAccessor recordAccessor = source.getRecords();
        long size = source.size();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        ArrayList threadQueues = new ArrayList(threadCount);
        int threadIndex = 0;
        while (threadIndex < threadCount) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue(10000);
            threadQueues.add(queue);
            index = threadIndex++;
            threads.add(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setComponent(COMPONENT_NAME)).setThreadName("reader-" + threadCount)).setInterruptableRunnable(() -> {
                for (long path = firstLeafPath + (long)index; path <= lastLeafPath; path += (long)threadCount) {
                    VirtualLeafBytes leafRecord = recordAccessor.findLeafRecord(path);
                    queue.put(Pair.of((Object)leafRecord.keyBytes(), (Object)leafRecord.valueBytes()));
                }
            })).build(true));
        }
        ArrayList buffers = new ArrayList(threadCount);
        ArrayList<Integer> bufferIndices = new ArrayList<Integer>(threadCount);
        for (int threadIndex2 = 0; threadIndex2 < threadCount; ++threadIndex2) {
            buffers.add(new ArrayList(10000));
            bufferIndices.add(0);
        }
        index = 0;
        while ((long)index < size) {
            try {
                int queueIndex = index % threadCount;
                BlockingQueue queue = (BlockingQueue)threadQueues.get(queueIndex);
                List buffer = (List)buffers.get(queueIndex);
                int bufferIndex = (Integer)bufferIndices.get(queueIndex);
                while (buffer.size() <= bufferIndex) {
                    buffer.clear();
                    queue.drainTo(buffer, 10000);
                    bufferIndex = 0;
                }
                handler.accept((Object)((Pair)buffer.get(bufferIndex)));
                bufferIndices.set(queueIndex, bufferIndex + 1);
            }
            catch (InterruptedException e) {
                threads.forEach(Thread::interrupt);
                throw e;
            }
            ++index;
        }
    }

    public static void extractVirtualMapDataC(ThreadManager threadManager, VirtualMap source, InterruptableConsumer<Pair<Bytes, Bytes>> handler, int threadCount) throws InterruptedException {
        long firstLeafPath = source.getMetadata().getFirstLeafPath();
        long lastLeafPath = source.getMetadata().getLastLeafPath();
        if (firstLeafPath == -1L || lastLeafPath == -1L) {
            return;
        }
        RecordAccessor recordAccessor = source.getRecords();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        AtomicReference throwable = new AtomicReference();
        for (int threadIndex = 0; threadIndex < threadCount; ++threadIndex) {
            long firstPath = firstLeafPath + (long)threadIndex;
            threads.add(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setComponent(COMPONENT_NAME)).setThreadName("reader-" + threadCount)).setInterruptableRunnable(() -> {
                block3: {
                    try {
                        for (long path = firstPath; path <= lastLeafPath; path += (long)threadCount) {
                            VirtualLeafBytes leafRecord = recordAccessor.findLeafRecord(path);
                            handler.accept((Object)Pair.of((Object)leafRecord.keyBytes(), (Object)leafRecord.valueBytes()));
                        }
                    }
                    catch (Throwable t) {
                        if (!throwable.compareAndSet(null, t)) break block3;
                        threads.forEach(Thread::interrupt);
                    }
                }
            })).build(true));
        }
        for (Thread thread : threads) {
            thread.join();
        }
        if (throwable.get() != null) {
            throw new InterruptedException(((Throwable)throwable.get()).toString());
        }
    }
}

