/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.node.app.blocks.impl.streaming.ConnectionState;
import com.hedera.node.app.blocks.impl.streaming.config.BlockNodeConfiguration;
import com.hedera.node.config.ConfigProvider;
import com.hedera.pbj.runtime.grpc.GrpcException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBlockNodeConnection
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(AbstractBlockNodeConnection.class);
    private static final Map<ConnectionType, AtomicInteger> connIdCtrByType = new EnumMap<ConnectionType, AtomicInteger>(ConnectionType.class);
    private final BlockNodeConfiguration configuration;
    private final String connectionId;
    private final ConfigProvider configProvider;
    private final AtomicReference<ConnectionState> stateRef;
    private final ConnectionType type;

    AbstractBlockNodeConnection(@NonNull ConnectionType type, @NonNull BlockNodeConfiguration configuration, @NonNull ConfigProvider configProvider) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is required");
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.connectionId = String.format("%s.%06d", type.key, connIdCtrByType.get((Object)type).incrementAndGet());
        this.stateRef = new AtomicReference<ConnectionState>(ConnectionState.UNINITIALIZED);
    }

    @NonNull
    final String connectionId() {
        return this.connectionId;
    }

    final void updateConnectionState(@NonNull ConnectionState newState) {
        this.updateConnectionState(null, newState);
    }

    final boolean updateConnectionState(@Nullable ConnectionState expectedState, @NonNull ConnectionState newState) {
        Objects.requireNonNull(newState, "newState is required");
        ConnectionState latestState = this.stateRef.get();
        if (!latestState.canTransitionTo(newState)) {
            logger.warn("{} Attempted to downgrade state from {} to {}, but this is not allowed", (Object)this, (Object)latestState, (Object)newState);
            throw new IllegalArgumentException("Attempted to downgrade state from " + String.valueOf((Object)latestState) + " to " + String.valueOf((Object)newState));
        }
        if (expectedState != null && expectedState != latestState) {
            logger.debug("{} Current state ({}) does not match expected state ({})", (Object)this, (Object)latestState, (Object)expectedState);
            return false;
        }
        if (!this.stateRef.compareAndSet(latestState, newState)) {
            logger.debug("{} Failed to transition state from {} to {} because current state does not match expected state", (Object)this, (Object)latestState, (Object)newState);
            return false;
        }
        logger.info("{} Connection state transitioned from {} to {}", (Object)this, (Object)latestState, (Object)newState);
        ConnectionState state = this.stateRef.get();
        if (state == ConnectionState.ACTIVE) {
            this.onActiveStateTransition();
        } else if (state.isTerminal()) {
            this.onTerminalStateTransition();
        }
        return true;
    }

    final boolean isActive() {
        return this.currentState() == ConnectionState.ACTIVE;
    }

    void onActiveStateTransition() {
    }

    void onTerminalStateTransition() {
    }

    abstract void initialize();

    @Override
    public abstract void close();

    @NonNull
    final ConfigProvider configProvider() {
        return this.configProvider;
    }

    @NonNull
    public final ConnectionState currentState() {
        return this.stateRef.get();
    }

    @NonNull
    public final BlockNodeConfiguration configuration() {
        return this.configuration;
    }

    protected GrpcException findGrpcException(Throwable t) {
        for (Throwable th = t; th != null; th = th.getCause()) {
            if (!(th instanceof GrpcException)) continue;
            GrpcException grpcException = (GrpcException)th;
            return grpcException;
        }
        return null;
    }

    public final String toString() {
        int port = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.configuration.streamingPort();
            case 1 -> this.configuration.servicePort();
        };
        return "[" + this.connectionId + "/" + this.configuration.address() + ":" + port + "/" + String.valueOf((Object)this.stateRef.get()) + "]";
    }

    public final boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBlockNodeConnection that = (AbstractBlockNodeConnection)o;
        return Objects.equals(this.configuration, that.configuration) && Objects.equals(this.connectionId, that.connectionId);
    }

    public final int hashCode() {
        return Objects.hash(this.configuration, this.connectionId);
    }

    static {
        for (ConnectionType type : ConnectionType.values()) {
            connIdCtrByType.put(type, new AtomicInteger(0));
        }
    }

    static enum ConnectionType {
        BLOCK_STREAMING("STR"),
        SERVER_STATUS("SVC");

        private final String key;

        private ConnectionType(String key) {
            this.key = key;
        }
    }
}

