/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform.prometheus;

import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.snapshot.Snapshot;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.util.Objects;
import org.hiero.consensus.metrics.platform.prometheus.AbstractMetricAdapter;
import org.hiero.consensus.metrics.platform.prometheus.PrometheusEndpoint;
import org.hiero.consensus.model.node.NodeId;

public class NumberAdapter
extends AbstractMetricAdapter {
    private final Gauge gauge;

    public NumberAdapter(CollectorRegistry registry, Metric metric, PrometheusEndpoint.AdapterType adapterType) {
        super(adapterType, metric);
        Objects.requireNonNull(registry, "registry must not be null");
        Objects.requireNonNull(metric, "metric must not be null");
        Gauge.Builder builder = (Gauge.Builder)this.assignCommonValues(new Gauge.Builder());
        if (adapterType == PrometheusEndpoint.AdapterType.PLATFORM) {
            builder.labelNames(new String[]{"node"});
        }
        this.gauge = (Gauge)builder.register(registry);
    }

    @Override
    public void update(Snapshot snapshot, NodeId nodeId) {
        Objects.requireNonNull(snapshot, "snapshot must not be null");
        double newValue = ((Number)snapshot.getValue()).doubleValue();
        if (this.adapterType == PrometheusEndpoint.AdapterType.GLOBAL) {
            this.gauge.set(newValue);
        } else {
            Objects.requireNonNull(nodeId, "nodeId must not be null");
            Gauge.Child child = (Gauge.Child)this.gauge.labels(new String[]{nodeId.toString()});
            child.set(newValue);
        }
    }

    @Override
    public void unregister(CollectorRegistry registry) {
        registry.unregister((Collector)this.gauge);
    }
}

