/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack.savepoints;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.handle.stack.BuilderSink;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class BuilderSinkImpl
implements BuilderSink {
    protected final List<StreamBuilder> precedingBuilders = new ArrayList<StreamBuilder>();
    protected final List<StreamBuilder> followingBuilders = new ArrayList<StreamBuilder>();
    private final int maxPreceding;
    private final int maxFollowing;
    private final int maxTotal;

    public BuilderSinkImpl(int maxPreceding, int maxFollowing) {
        this.maxPreceding = maxPreceding;
        this.maxFollowing = maxFollowing;
        this.maxTotal = maxPreceding == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxPreceding + maxFollowing;
    }

    public BuilderSinkImpl(int maxTotal) {
        this.maxPreceding = maxTotal;
        this.maxFollowing = maxTotal;
        this.maxTotal = maxTotal;
    }

    @Override
    public List<StreamBuilder> allBuilders() {
        if (this.precedingBuilders.isEmpty()) {
            return this.followingBuilders;
        }
        ArrayList<StreamBuilder> allBuilders = new ArrayList<StreamBuilder>(this.precedingBuilders);
        allBuilders.addAll(this.followingBuilders);
        return allBuilders;
    }

    @Override
    public boolean hasBuilderOtherThan(@NonNull StreamBuilder baseBuilder) {
        Objects.requireNonNull(baseBuilder);
        for (StreamBuilder builder : this.precedingBuilders) {
            if (builder == baseBuilder) continue;
            return true;
        }
        for (StreamBuilder builder : this.followingBuilders) {
            if (builder == baseBuilder) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void forEachOtherBuilder(@NonNull Consumer<T> consumer, @NonNull Class<T> builderType, @NonNull StreamBuilder baseBuilder) {
        Objects.requireNonNull(builderType);
        Objects.requireNonNull(consumer);
        Objects.requireNonNull(baseBuilder);
        for (StreamBuilder builder : this.followingBuilders) {
            if (builder == baseBuilder) continue;
            consumer.accept(builderType.cast(builder));
        }
        for (StreamBuilder builder : this.precedingBuilders) {
            if (builder == baseBuilder) continue;
            consumer.accept(builderType.cast(builder));
        }
    }

    @Override
    public void flushInOrder(@NonNull BuilderSink parentSink) {
        Objects.requireNonNull(parentSink);
        parentSink.addAllPreceding(this.precedingBuilders);
        parentSink.addAllFollowing(this.followingBuilders);
    }

    @Override
    public void flushPreceding(@NonNull BuilderSink parentSink) {
        Objects.requireNonNull(parentSink);
        parentSink.addAllPreceding(this.allBuilders());
    }

    @Override
    public void flushFollowing(@NonNull BuilderSink parentSink) {
        Objects.requireNonNull(parentSink);
        parentSink.addAllFollowing(this.allBuilders());
    }

    @Override
    public void addPrecedingOrThrow(@NonNull StreamBuilder builder) {
        Objects.requireNonNull(builder);
        if (this.precedingCapacity() == 0) {
            throw new HandleException(ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED);
        }
        this.precedingBuilders.add(builder);
    }

    @Override
    public void addFollowingOrThrow(@NonNull StreamBuilder builder) {
        Objects.requireNonNull(builder);
        if (this.followingCapacity() == 0) {
            throw new HandleException(ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED);
        }
        this.followingBuilders.add(builder);
    }

    @Override
    public int precedingCapacity() {
        return Math.min(this.maxPreceding - this.precedingBuilders.size(), this.maxTotal - this.numBuilders());
    }

    @Override
    public int followingCapacity() {
        return Math.min(this.maxFollowing - this.followingBuilders.size(), this.maxTotal - this.numBuilders());
    }

    private int numBuilders() {
        return this.precedingBuilders.size() + this.followingBuilders.size();
    }
}

