/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.io.streams.DebuggableDataInputStream;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.streams.SerializableDataInputStream;

public final class StreamDebugUtils {
    private static final Logger logger = LogManager.getLogger(StreamDebugUtils.class);

    private StreamDebugUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserializeAndDebugOnFailure(InputStreamBuilder inputStreamBuilder, Deserializer<T> deserializer) throws IOException {
        try (InputStream baseStream = inputStreamBuilder.buildStream();){
            SerializableDataInputStream in2 = new SerializableDataInputStream(baseStream);
            T t = deserializer.deserialize(in2);
            return t;
        }
        catch (Throwable ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Deserialization failure. Will re-attempt deserialization with extra debug information.", ex);
            DebuggableDataInputStream in3 = null;
            try (InputStream baseStream2 = inputStreamBuilder.buildStream();){
                in3 = new DebuggableDataInputStream(baseStream2);
                deserializer.deserialize(in3);
            }
            catch (Throwable innerEx) {
                try {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Deserialization re-attempt also encountered a failure.", innerEx);
                }
                catch (Throwable throwable) {
                    if (!(in3 instanceof DebuggableDataInputStream)) throw throwable;
                    DebuggableDataInputStream debugIn = in3;
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Deserialization stack trace:\n{}", (Object)debugIn.getFormattedStackTrace());
                    throw throwable;
                }
                if (!(in3 instanceof DebuggableDataInputStream)) throw ex;
                DebuggableDataInputStream debugIn = in3;
                logger.error(LogMarker.EXCEPTION.getMarker(), "Deserialization stack trace:\n{}", (Object)debugIn.getFormattedStackTrace());
                throw ex;
            }
            if (!(in3 instanceof DebuggableDataInputStream)) throw ex;
            DebuggableDataInputStream debugIn = in3;
            logger.error(LogMarker.EXCEPTION.getMarker(), "Deserialization stack trace:\n{}", (Object)debugIn.getFormattedStackTrace());
            throw ex;
        }
    }

    public static interface InputStreamBuilder {
        public InputStream buildStream() throws IOException;
    }

    @FunctionalInterface
    public static interface Deserializer<T> {
        public T deserialize(SerializableDataInputStream var1) throws IOException;
    }
}

