/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.hints;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.hints.HintsScheme;
import com.hedera.hapi.node.state.hints.codec.HintsConstructionJsonCodec;
import com.hedera.hapi.node.state.hints.codec.HintsConstructionProtoCodec;
import com.hedera.hapi.node.state.hints.schema.HintsConstructionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HintsConstruction {
    public static final Codec<HintsConstruction> PROTOBUF = new HintsConstructionProtoCodec();
    public static final JsonCodec<HintsConstruction> JSON = new HintsConstructionJsonCodec();
    public static final HintsConstruction DEFAULT = HintsConstruction.newBuilder().build();
    private final long constructionId;
    @NonNull
    private final Bytes sourceRosterHash;
    @NonNull
    private final Bytes targetRosterHash;
    private final OneOf<PreprocessingStateOneOfType> preprocessingState;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public HintsConstruction(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<PreprocessingStateOneOfType> preprocessingState) {
        this.$unknownFields = null;
        this.constructionId = constructionId;
        this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
        Bytes bytes = this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
        if (preprocessingState == null) {
            throw new NullPointerException("Parameter 'preprocessingState' must be supplied and can not be null");
        }
        this.preprocessingState = preprocessingState;
    }

    public HintsConstruction(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<PreprocessingStateOneOfType> preprocessingState, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.constructionId = constructionId;
        this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
        Bytes bytes = this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
        if (preprocessingState == null) {
            throw new NullPointerException("Parameter 'preprocessingState' must be supplied and can not be null");
        }
        this.preprocessingState = preprocessingState;
    }

    public long constructionId() {
        return this.constructionId;
    }

    public Bytes sourceRosterHash() {
        return this.sourceRosterHash;
    }

    public Bytes targetRosterHash() {
        return this.targetRosterHash;
    }

    public OneOf<PreprocessingStateOneOfType> preprocessingState() {
        return this.preprocessingState;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)HintsConstructionSchema.CONSTRUCTION_ID, (long)this.constructionId, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HintsConstructionSchema.SOURCE_ROSTER_HASH, (RandomAccessData)this.sourceRosterHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HintsConstructionSchema.TARGET_ROSTER_HASH, (RandomAccessData)this.targetRosterHash, (boolean)true);
            if (this.preprocessingState.kind() == PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HintsConstructionSchema.GRACE_PERIOD_END_TIME, (Object)((Timestamp)this.preprocessingState.as()), Timestamp.PROTOBUF);
            }
            if (this.preprocessingState.kind() == PreprocessingStateOneOfType.PREPROCESSING_START_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HintsConstructionSchema.PREPROCESSING_START_TIME, (Object)((Timestamp)this.preprocessingState.as()), Timestamp.PROTOBUF);
            }
            if (this.preprocessingState.kind() == PreprocessingStateOneOfType.HINTS_SCHEME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HintsConstructionSchema.HINTS_SCHEME, (Object)((HintsScheme)this.preprocessingState.as()), HintsScheme.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.constructionId != HintsConstruction.DEFAULT.constructionId) {
                result = 31 * result + Long.hashCode(this.constructionId);
            }
            if (this.sourceRosterHash != null && !this.sourceRosterHash.equals((Object)HintsConstruction.DEFAULT.sourceRosterHash)) {
                result = 31 * result + this.sourceRosterHash.hashCode();
            }
            if (this.targetRosterHash != null && !this.targetRosterHash.equals((Object)HintsConstruction.DEFAULT.targetRosterHash)) {
                result = 31 * result + this.targetRosterHash.hashCode();
            }
            if (this.preprocessingState != null && !this.preprocessingState.equals(HintsConstruction.DEFAULT.preprocessingState)) {
                result = 31 * result + this.preprocessingState.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HintsConstruction thatObj = (HintsConstruction)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.constructionId != thatObj.constructionId) {
            return false;
        }
        if (this.sourceRosterHash == null && thatObj.sourceRosterHash != null) {
            return false;
        }
        if (this.sourceRosterHash != null && !this.sourceRosterHash.equals((Object)thatObj.sourceRosterHash)) {
            return false;
        }
        if (this.targetRosterHash == null && thatObj.targetRosterHash != null) {
            return false;
        }
        if (this.targetRosterHash != null && !this.targetRosterHash.equals((Object)thatObj.targetRosterHash)) {
            return false;
        }
        if (this.preprocessingState == null && thatObj.preprocessingState != null) {
            return false;
        }
        if (this.preprocessingState != null && !this.preprocessingState.equals(thatObj.preprocessingState)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "HintsConstruction[constructionId=" + this.constructionId + ", sourceRosterHash=" + String.valueOf(this.sourceRosterHash) + ", targetRosterHash=" + String.valueOf(this.targetRosterHash) + ", preprocessingState=" + String.valueOf(this.preprocessingState) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Timestamp gracePeriodEndTime() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME ? (Timestamp)this.preprocessingState.value() : null;
    }

    public boolean hasGracePeriodEndTime() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME;
    }

    public Timestamp gracePeriodEndTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasGracePeriodEndTime() ? this.gracePeriodEndTime() : defaultValue;
    }

    @NonNull
    public Timestamp gracePeriodEndTimeOrThrow() {
        return Objects.requireNonNull(this.gracePeriodEndTime(), "Field gracePeriodEndTime is null");
    }

    @Nullable
    public Timestamp preprocessingStartTime() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.PREPROCESSING_START_TIME ? (Timestamp)this.preprocessingState.value() : null;
    }

    public boolean hasPreprocessingStartTime() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.PREPROCESSING_START_TIME;
    }

    public Timestamp preprocessingStartTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasPreprocessingStartTime() ? this.preprocessingStartTime() : defaultValue;
    }

    @NonNull
    public Timestamp preprocessingStartTimeOrThrow() {
        return Objects.requireNonNull(this.preprocessingStartTime(), "Field preprocessingStartTime is null");
    }

    @Nullable
    public HintsScheme hintsScheme() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.HINTS_SCHEME ? (HintsScheme)this.preprocessingState.value() : null;
    }

    public boolean hasHintsScheme() {
        return this.preprocessingState.kind() == PreprocessingStateOneOfType.HINTS_SCHEME;
    }

    public HintsScheme hintsSchemeOrElse(@NonNull HintsScheme defaultValue) {
        return this.hasHintsScheme() ? this.hintsScheme() : defaultValue;
    }

    @NonNull
    public HintsScheme hintsSchemeOrThrow() {
        return Objects.requireNonNull(this.hintsScheme(), "Field hintsScheme is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.constructionId, this.sourceRosterHash, this.targetRosterHash, this.preprocessingState, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum PreprocessingStateOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        GRACE_PERIOD_END_TIME(4, "grace_period_end_time"),
        PREPROCESSING_START_TIME(5, "preprocessing_start_time"),
        HINTS_SCHEME(6, "hints_scheme");

        private final int protoOrdinal;
        private final String protoName;

        private PreprocessingStateOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static PreprocessingStateOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 4 -> GRACE_PERIOD_END_TIME;
                case 5 -> PREPROCESSING_START_TIME;
                case 6 -> HINTS_SCHEME;
                default -> UNSET;
            };
        }

        public static PreprocessingStateOneOfType fromString(String name) {
            return switch (name) {
                case "grace_period_end_time", "GRACE_PERIOD_END_TIME" -> GRACE_PERIOD_END_TIME;
                case "preprocessing_start_time", "PREPROCESSING_START_TIME" -> PREPROCESSING_START_TIME;
                case "hints_scheme", "HINTS_SCHEME" -> HINTS_SCHEME;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static PreprocessingStateOneOfType fromObject(Object obj) {
            if (obj == null) {
                return PreprocessingStateOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof PreprocessingStateOneOfType) {
                PreprocessingStateOneOfType pbjEnum = (PreprocessingStateOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<PreprocessingStateOneOfType> fromObjects(List<?> list) {
            return list.stream().map(PreprocessingStateOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof PreprocessingStateOneOfType) {
                PreprocessingStateOneOfType pbjEnum = (PreprocessingStateOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither PreprocessingStateOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(PreprocessingStateOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof PreprocessingStateOneOfType) {
                PreprocessingStateOneOfType e1 = (PreprocessingStateOneOfType)((Object)o1);
                if (o2 instanceof PreprocessingStateOneOfType) {
                    PreprocessingStateOneOfType e2 = (PreprocessingStateOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof PreprocessingStateOneOfType) {
                PreprocessingStateOneOfType e1 = (PreprocessingStateOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither PreprocessingStateOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof PreprocessingStateOneOfType) {
                PreprocessingStateOneOfType e2 = (PreprocessingStateOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither PreprocessingStateOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        private long constructionId = 0L;
        @NonNull
        private Bytes sourceRosterHash = Bytes.EMPTY;
        @NonNull
        private Bytes targetRosterHash = Bytes.EMPTY;
        private OneOf<PreprocessingStateOneOfType> preprocessingState = HintsConstructionProtoCodec.PREPROCESSING_STATE_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<PreprocessingStateOneOfType> preprocessingState) {
            this.$unknownFields = null;
            this.constructionId = constructionId;
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            this.preprocessingState = preprocessingState;
        }

        public Builder(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<PreprocessingStateOneOfType> preprocessingState, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.constructionId = constructionId;
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            this.preprocessingState = preprocessingState;
        }

        public HintsConstruction build() {
            return new HintsConstruction(this.constructionId, this.sourceRosterHash, this.targetRosterHash, this.preprocessingState);
        }

        public Builder constructionId(long constructionId) {
            this.constructionId = constructionId;
            return this;
        }

        public Builder sourceRosterHash(@NonNull Bytes sourceRosterHash) {
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            return this;
        }

        public Builder targetRosterHash(@NonNull Bytes targetRosterHash) {
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            return this;
        }

        public void clearPreprocessingState() {
            this.preprocessingState = HintsConstructionProtoCodec.PREPROCESSING_STATE_UNSET;
        }

        public Builder gracePeriodEndTime(@Nullable Timestamp gracePeriodEndTime) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME, (Object)gracePeriodEndTime);
            return this;
        }

        public Builder gracePeriodEndTime(Timestamp.Builder builder) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME, (Object)builder.build());
            return this;
        }

        public Builder preprocessingStartTime(@Nullable Timestamp preprocessingStartTime) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.PREPROCESSING_START_TIME, (Object)preprocessingStartTime);
            return this;
        }

        public Builder preprocessingStartTime(Timestamp.Builder builder) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.PREPROCESSING_START_TIME, (Object)builder.build());
            return this;
        }

        public Builder hintsScheme(@Nullable HintsScheme hintsScheme) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.HINTS_SCHEME, (Object)hintsScheme);
            return this;
        }

        public Builder hintsScheme(HintsScheme.Builder builder) {
            this.preprocessingState = new OneOf((Enum)PreprocessingStateOneOfType.HINTS_SCHEME, (Object)builder.build());
            return this;
        }

        public long constructionId() {
            return this.constructionId;
        }

        public Bytes sourceRosterHash() {
            return this.sourceRosterHash;
        }

        public Bytes targetRosterHash() {
            return this.targetRosterHash;
        }

        public OneOf<PreprocessingStateOneOfType> preprocessingState() {
            return this.preprocessingState;
        }
    }
}

