/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.associations;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenAssociateTransactionBody;
import com.hedera.hapi.node.token.TokenDissociateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.associations.AssociationsTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AssociationsDecoder {
    @Inject
    public AssociationsDecoder() {
    }

    public TransactionBody decodeHrcAssociate(@NonNull HtsCallAttempt attempt) {
        return TransactionBody.newBuilder().tokenAssociate(TokenAssociateTransactionBody.newBuilder().account(attempt.senderId()).tokens(new TokenID[]{Objects.requireNonNull(attempt.redirectTokenId())})).build();
    }

    public TransactionBody decodeHrcDissociate(@NonNull HtsCallAttempt attempt) {
        return TransactionBody.newBuilder().tokenDissociate(TokenDissociateTransactionBody.newBuilder().account(attempt.senderId()).tokens(new TokenID[]{Objects.requireNonNull(attempt.redirectTokenId())})).build();
    }

    public TransactionBody decodeAssociateOne(@NonNull HtsCallAttempt attempt) {
        Tuple call = AssociationsTranslator.ASSOCIATE_ONE.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.association(attempt, (Address)call.get(0), (Address)call.get(1)));
    }

    public TransactionBody decodeAssociateMany(@NonNull HtsCallAttempt attempt) {
        Tuple call = AssociationsTranslator.ASSOCIATE_MANY.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.associations(attempt, (Address)call.get(0), (Address[])call.get(1)));
    }

    public TransactionBody decodeDissociateOne(@NonNull HtsCallAttempt attempt) {
        Tuple call = AssociationsTranslator.DISSOCIATE_ONE.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.dissociation(attempt, (Address)call.get(0), (Address)call.get(1)));
    }

    public TransactionBody decodeDissociateMany(@NonNull HtsCallAttempt attempt) {
        Tuple call = AssociationsTranslator.DISSOCIATE_MANY.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.dissociations(attempt, (Address)call.get(0), (Address[])call.get(1)));
    }

    private TransactionBody bodyOf(@NonNull TokenAssociateTransactionBody association) {
        return TransactionBody.newBuilder().tokenAssociate(association).build();
    }

    private TransactionBody bodyOf(@NonNull TokenDissociateTransactionBody dissociation) {
        return TransactionBody.newBuilder().tokenDissociate(dissociation).build();
    }

    private TokenAssociateTransactionBody association(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, @NonNull Address tokenAddress) {
        return this.internalAssociations(attempt, accountAddress, tokenAddress);
    }

    private TokenAssociateTransactionBody associations(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, @NonNull Address[] tokenAddresses) {
        return this.internalAssociations(attempt, accountAddress, tokenAddresses);
    }

    private TokenDissociateTransactionBody dissociation(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, @NonNull Address tokenAddress) {
        return this.internalDissociations(attempt, accountAddress, tokenAddress);
    }

    private TokenDissociateTransactionBody dissociations(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, @NonNull Address[] tokenAddresses) {
        return this.internalDissociations(attempt, accountAddress, tokenAddresses);
    }

    private TokenAssociateTransactionBody internalAssociations(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, Address ... tokenAddresses) {
        return TokenAssociateTransactionBody.newBuilder().account(attempt.addressIdConverter().convert(accountAddress)).tokens(ConversionUtils.asTokenIds(attempt.nativeOperations().entityIdFactory(), tokenAddresses)).build();
    }

    private TokenDissociateTransactionBody internalDissociations(@NonNull HtsCallAttempt attempt, @NonNull Address accountAddress, Address ... tokenAddresses) {
        return TokenDissociateTransactionBody.newBuilder().account(attempt.addressIdConverter().convert(accountAddress)).tokens(ConversionUtils.asTokenIds(attempt.nativeOperations().entityIdFactory(), tokenAddresses)).build();
    }
}

