/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.vm;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.binary.QueueState;
import com.swirlds.state.merkle.vm.VirtualMapQueueHelper;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

public class VirtualMapWritableQueueState<V>
extends WritableQueueStateBase<V> {
    @NonNull
    private final VirtualMapQueueHelper<V> virtualMapQueueHelper;

    public VirtualMapWritableQueueState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, Objects.requireNonNull(label));
        this.virtualMapQueueHelper = new VirtualMapQueueHelper<V>(stateId, valueCodec, virtualMap);
    }

    protected void addToDataSource(@NonNull V value) {
        QueueState state = this.virtualMapQueueHelper.getState();
        if (state == null) {
            state = new QueueState(1L, 1L);
        }
        this.virtualMapQueueHelper.addToStore(state.tail(), value);
        this.virtualMapQueueHelper.updateState(state.elementAdded());
    }

    protected void removeFromDataSource() {
        QueueState state = Objects.requireNonNull(this.virtualMapQueueHelper.getState());
        if (!VirtualMapQueueHelper.isEmpty(state)) {
            this.virtualMapQueueHelper.removeFromStore(state.head());
            this.virtualMapQueueHelper.updateState(state.elementRemoved());
        }
    }

    @NonNull
    protected Iterator<V> iterateOnDataSource() {
        QueueState state = this.virtualMapQueueHelper.getState();
        if (state == null) {
            return this.virtualMapQueueHelper.iterateOnDataSource(0L, 0L);
        }
        return this.virtualMapQueueHelper.iterateOnDataSource(state.head(), state.tail());
    }
}

