/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.status;

import com.swirlds.base.formatting.UnitFormatter;
import com.swirlds.base.time.Time;
import com.swirlds.base.units.TimeUnit;
import com.swirlds.base.units.Unit;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.PlatformStatusPayload;
import com.swirlds.platform.system.status.IllegalPlatformStatusException;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.system.status.PlatformStatusMetrics;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import com.swirlds.platform.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.platform.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.platform.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.platform.system.status.actions.TimeElapsedAction;
import com.swirlds.platform.system.status.logic.PlatformStatusLogic;
import com.swirlds.platform.system.status.logic.StartingUpStatusLogic;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.pces.actions.DoneReplayingEventsAction;
import org.hiero.consensus.pces.actions.StartedReplayingEventsAction;

public class StatusStateMachine {
    private static final Logger logger = LogManager.getLogger(StatusStateMachine.class);
    private final Time time;
    private PlatformStatusLogic currentStatusLogic;
    private Instant currentStatusStartTime;
    private final PlatformStatusMetrics metrics;

    public StatusStateMachine(@NonNull PlatformContext platformContext) {
        this.time = platformContext.getTime();
        this.currentStatusLogic = new StartingUpStatusLogic((PlatformStatusConfig)platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class));
        this.currentStatusStartTime = this.time.now();
        this.metrics = new PlatformStatusMetrics(platformContext);
    }

    @Nullable
    private PlatformStatusLogic getNewLogic(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        try {
            PlatformStatusAction platformStatusAction = action;
            Objects.requireNonNull(platformStatusAction);
            PlatformStatusAction platformStatusAction2 = platformStatusAction;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CatastrophicFailureAction.class, DoneReplayingEventsAction.class, FallenBehindAction.class, FreezePeriodEnteredAction.class, ReconnectCompleteAction.class, SelfEventReachedConsensusAction.class, StartedReplayingEventsAction.class, StateWrittenToDiskAction.class, TimeElapsedAction.class}, (Object)platformStatusAction2, n)) {
                case 0 -> {
                    CatastrophicFailureAction a = (CatastrophicFailureAction)platformStatusAction2;
                    yield this.currentStatusLogic.processCatastrophicFailureAction(a);
                }
                case 1 -> {
                    DoneReplayingEventsAction a = (DoneReplayingEventsAction)platformStatusAction2;
                    yield this.currentStatusLogic.processDoneReplayingEventsAction(a);
                }
                case 2 -> {
                    FallenBehindAction a = (FallenBehindAction)platformStatusAction2;
                    yield this.currentStatusLogic.processFallenBehindAction(a);
                }
                case 3 -> {
                    FreezePeriodEnteredAction a = (FreezePeriodEnteredAction)platformStatusAction2;
                    yield this.currentStatusLogic.processFreezePeriodEnteredAction(a);
                }
                case 4 -> {
                    ReconnectCompleteAction a = (ReconnectCompleteAction)platformStatusAction2;
                    yield this.currentStatusLogic.processReconnectCompleteAction(a);
                }
                case 5 -> {
                    SelfEventReachedConsensusAction a = (SelfEventReachedConsensusAction)platformStatusAction2;
                    yield this.currentStatusLogic.processSelfEventReachedConsensusAction(a);
                }
                case 6 -> {
                    StartedReplayingEventsAction a = (StartedReplayingEventsAction)platformStatusAction2;
                    yield this.currentStatusLogic.processStartedReplayingEventsAction(a);
                }
                case 7 -> {
                    StateWrittenToDiskAction a = (StateWrittenToDiskAction)platformStatusAction2;
                    yield this.currentStatusLogic.processStateWrittenToDiskAction(a);
                }
                case 8 -> {
                    TimeElapsedAction a = (TimeElapsedAction)platformStatusAction2;
                    yield this.currentStatusLogic.processTimeElapsedAction(a);
                }
                default -> throw new IllegalArgumentException("Unknown action type: " + action.getClass().getName());
            };
        }
        catch (IllegalPlatformStatusException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public PlatformStatus submitStatusAction(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        PlatformStatusLogic newLogic = this.getNewLogic(action);
        if (newLogic == null || newLogic == this.currentStatusLogic) {
            return null;
        }
        String previousStatusName = this.currentStatusLogic.getStatus().name();
        String newStatusName = newLogic.getStatus().name();
        Duration statusDuration = Duration.between(this.currentStatusStartTime, this.time.now());
        UnitFormatter unitFormatter = new UnitFormatter(statusDuration.toMillis(), (Unit)TimeUnit.UNIT_MILLISECONDS);
        String statusChangeMessage = "Platform spent %s in %s. Now in %s".formatted(unitFormatter.render(), previousStatusName, newStatusName);
        logger.info(LogMarker.PLATFORM_STATUS.getMarker(), () -> new PlatformStatusPayload(statusChangeMessage, previousStatusName, newStatusName).toString());
        this.currentStatusLogic = newLogic;
        PlatformStatus newStatus = this.currentStatusLogic.getStatus();
        this.currentStatusStartTime = this.time.now();
        this.metrics.setCurrentStatus(newStatus);
        return newStatus;
    }
}

