/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl.consensus;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.model.event.Event;

public final class ConsensusUtils {
    private ConsensusUtils() {
    }

    public static boolean coin(@NonNull Event event) {
        return event.getEventCore().coin() % 2L == 0L;
    }

    @NonNull
    public static Instant calcMinTimestampForNextEvent(@NonNull Instant lastTransTimestamp) {
        Instant t = lastTransTimestamp.plusNanos(1000L);
        t = t.plusNanos(999L - (1000L + (long)t.getNano() - 1L) % 1000L);
        return t;
    }

    @NonNull
    public static byte[] generateWhitening(@NonNull Iterable<EventImpl> judges) {
        byte[] whitening = new byte[384];
        for (EventImpl w : judges) {
            if (w == null) continue;
            Bytes sig = w.getBaseHash().getBytes();
            int mn = Math.min(whitening.length, (int)sig.length());
            for (int i = 0; i < mn; ++i) {
                int n = i;
                whitening[n] = (byte)(whitening[n] ^ sig.getByte((long)i));
            }
        }
        return whitening;
    }
}

