/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;

public class HederaExceptionalHaltReason {
    public static final ExceptionalHaltReason INVALID_SOLIDITY_ADDRESS = HederaExceptionalHalt.INVALID_SOLIDITY_ADDRESS;
    public static final ExceptionalHaltReason SELF_DESTRUCT_TO_SELF = HederaExceptionalHalt.SELF_DESTRUCT_TO_SELF;
    public static final ExceptionalHaltReason INVALID_SIGNATURE = HederaExceptionalHalt.INVALID_SIGNATURE;
    public static final ExceptionalHaltReason CONTRACT_IS_TREASURY = HederaExceptionalHalt.CONTRACT_IS_TREASURY;
    public static final ExceptionalHaltReason CONTRACT_STILL_OWNS_NFTS = HederaExceptionalHalt.CONTRACT_STILL_OWNS_NFTS;
    public static final ExceptionalHaltReason TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES = HederaExceptionalHalt.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES;
    public static final ExceptionalHaltReason ERROR_DECODING_PRECOMPILE_INPUT = HederaExceptionalHalt.ERROR_DECODING_PRECOMPILE_INPUT;
    public static final ExceptionalHaltReason FAILURE_DURING_LAZY_ACCOUNT_CREATE = HederaExceptionalHalt.FAILURE_DURING_LAZY_ACCOUNT_CREATION;
    public static final ExceptionalHaltReason INVALID_FEE_SUBMITTED = HederaExceptionalHalt.INVALID_FEE_SUBMITTED;
    public static final ExceptionalHaltReason NOT_SUPPORTED = HederaExceptionalHalt.NOT_SUPPORTED;

    static enum HederaExceptionalHalt implements ExceptionalHaltReason
    {
        INVALID_SOLIDITY_ADDRESS("Invalid account reference"),
        SELF_DESTRUCT_TO_SELF("Self destruct to the same address"),
        CONTRACT_IS_TREASURY("Token treasuries cannot be deleted"),
        INVALID_SIGNATURE("Invalid signature"),
        TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES("Accounts with positive fungible token balances cannot be deleted"),
        CONTRACT_STILL_OWNS_NFTS("Accounts who own nfts cannot be deleted"),
        ERROR_DECODING_PRECOMPILE_INPUT("Error when decoding precompile input."),
        FAILURE_DURING_LAZY_ACCOUNT_CREATION("Failure during lazy account creation"),
        NOT_SUPPORTED("Not supported."),
        INVALID_FEE_SUBMITTED("Invalid fee submitted for an EVM call.");

        final String description;

        private HederaExceptionalHalt(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

