/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Objects;

public class VirtualLeafBytes<V> {
    public static final FieldDefinition FIELD_LEAFRECORD_PATH = new FieldDefinition("path", FieldType.FIXED64, false, true, false, 1);
    public static final FieldDefinition FIELD_LEAFRECORD_KEY = new FieldDefinition("key", FieldType.BYTES, false, true, false, 2);
    public static final FieldDefinition FIELD_LEAFRECORD_VALUE = new FieldDefinition("value", FieldType.BYTES, false, true, false, 3);
    private final long path;
    private final long pathOnDisk;
    private final Bytes keyBytes;
    private V value;
    private Codec<V> valueCodec;
    private Bytes valueBytes;

    public VirtualLeafBytes(long path, @NonNull Bytes keyBytes, @Nullable V value, @Nullable Codec<V> valueCodec) {
        this(path, -1L, keyBytes, value, valueCodec, null);
    }

    private VirtualLeafBytes(long path, long pathOnDisk, @NonNull Bytes keyBytes, @Nullable V value, @Nullable Codec<V> valueCodec) {
        this(path, pathOnDisk, keyBytes, value, valueCodec, null);
    }

    public VirtualLeafBytes(long path, @NonNull Bytes keyBytes, @Nullable Bytes valueBytes) {
        this(path, -1L, keyBytes, null, null, valueBytes);
    }

    private VirtualLeafBytes(long path, long pathOnDisk, @NonNull Bytes keyBytes, @Nullable Bytes valueBytes) {
        this(path, pathOnDisk, keyBytes, null, null, valueBytes);
    }

    private VirtualLeafBytes(long path, long pathOnDisk, @NonNull Bytes keyBytes, @Nullable V value, @Nullable Codec<V> valueCodec, @Nullable Bytes valueBytes) {
        this.path = path;
        this.pathOnDisk = pathOnDisk;
        this.keyBytes = Objects.requireNonNull(keyBytes);
        this.value = value;
        this.valueCodec = valueCodec;
        this.valueBytes = valueBytes;
        if (value != null && valueCodec == null) {
            throw new IllegalArgumentException("Null codec for non-null value");
        }
    }

    public long path() {
        return this.path;
    }

    public boolean isNewOrMoved() {
        assert (this.path >= 0L) : "isNewOrMoved() must not be called for records with invalid paths";
        return this.path != this.pathOnDisk;
    }

    public Bytes keyBytes() {
        return this.keyBytes;
    }

    public V value(Codec<V> valueCodec) {
        if (this.value == null) {
            if (this.valueBytes != null) {
                assert (this.valueCodec == null || this.valueCodec.equals(valueCodec));
                this.valueCodec = valueCodec;
                try {
                    this.value = valueCodec.parse(this.valueBytes);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Failed to deserialize a value from bytes", e);
                }
            }
        } else {
            assert (valueCodec != null);
            if (!this.valueCodec.equals(valueCodec)) {
                throw new IllegalStateException("Value codec mismatch");
            }
        }
        return this.value;
    }

    public Bytes valueBytes() {
        if (this.valueBytes == null && this.value != null) {
            assert (this.valueCodec != null);
            byte[] vb = new byte[this.valueCodec.measureRecord(this.value)];
            try {
                this.valueCodec.write(this.value, (WritableSequentialData)BufferedData.wrap((byte[])vb));
                this.valueBytes = Bytes.wrap((byte[])vb);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize a value to bytes", e);
            }
        }
        return this.valueBytes;
    }

    public VirtualLeafBytes<V> withPath(long newPath) {
        return new VirtualLeafBytes<V>(newPath, this.pathOnDisk, this.keyBytes, this.value, this.valueCodec, this.valueBytes);
    }

    public VirtualLeafBytes<V> withValue(V newValue, Codec<V> newValueCodec) {
        return new VirtualLeafBytes<V>(this.path, this.pathOnDisk, this.keyBytes, newValue, newValueCodec);
    }

    public VirtualLeafBytes<V> withValueBytes(Bytes newValueBytes) {
        return new VirtualLeafBytes<V>(this.path, this.pathOnDisk, this.keyBytes, newValueBytes);
    }

    public static <V> VirtualLeafBytes<V> parseFrom(ReadableSequentialData in) {
        if (in == null) {
            return null;
        }
        long path = 0L;
        Bytes keyBytes = null;
        Bytes valueBytes = null;
        while (in.hasRemaining()) {
            int len;
            int field = in.readVarInt(false);
            int tag = field >> 3;
            if (tag == FIELD_LEAFRECORD_PATH.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_FIXED_64_BIT.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                path = in.readLong();
                continue;
            }
            if (tag == FIELD_LEAFRECORD_KEY.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                len = in.readVarInt(false);
                keyBytes = in.readBytes(len);
                continue;
            }
            if (tag == FIELD_LEAFRECORD_VALUE.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                len = in.readVarInt(false);
                valueBytes = len == 0 ? Bytes.EMPTY : in.readBytes(len);
                continue;
            }
            throw new IllegalArgumentException("Unknown field: " + field);
        }
        Objects.requireNonNull(keyBytes, "Missing key bytes in the input");
        return new VirtualLeafBytes<V>(path, path, keyBytes, valueBytes);
    }

    public int getSizeInBytes() {
        int size = 0;
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_LEAFRECORD_PATH);
        size += 8;
        size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_LEAFRECORD_KEY, (int)Math.toIntExact(this.keyBytes.length()));
        int valueBytesLen = this.valueBytes != null ? Math.toIntExact(this.valueBytes.length()) : (this.value != null ? this.valueCodec.measureRecord(this.value) : -1);
        if (valueBytesLen >= 0) {
            size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_LEAFRECORD_VALUE, (int)valueBytesLen);
        }
        return size;
    }

    public void writeTo(WritableSequentialData out) {
        long pos = out.position();
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_LEAFRECORD_PATH);
        out.writeLong(this.path);
        Bytes kb = this.keyBytes();
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_LEAFRECORD_KEY);
        out.writeVarInt(Math.toIntExact(kb.length()), false);
        kb.writeTo(out);
        Bytes vb = this.valueBytes();
        if (vb != null) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_LEAFRECORD_VALUE);
            out.writeVarInt(Math.toIntExact(vb.length()), false);
            vb.writeTo(out);
        }
        assert (out.position() == pos + (long)this.getSizeInBytes()) : "pos=" + pos + ", out.position()=" + out.position() + ", size=" + this.getSizeInBytes();
    }

    public void writeToForHashing(WritableSequentialData out) {
        out.writeByte((byte)0);
        Bytes kb = this.keyBytes();
        Bytes vb = this.valueBytes();
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_LEAFRECORD_KEY);
        out.writeVarInt(Math.toIntExact(kb.length()), false);
        kb.writeTo(out);
        if (vb != null) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_LEAFRECORD_VALUE);
            out.writeVarInt(Math.toIntExact(vb.length()), false);
            vb.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(this.path, this.keyBytes, this.valueBytes());
    }

    public boolean equals(Object o) {
        if (!(o instanceof VirtualLeafBytes)) {
            return false;
        }
        VirtualLeafBytes other = (VirtualLeafBytes)o;
        return this.path == other.path && Objects.equals(this.keyBytes, other.keyBytes) && Objects.equals(this.valueBytes(), other.valueBytes());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("path", (Object)this.path).append("keyBytes", (Object)this.keyBytes).append("valueBytes", (Object)this.valueBytes()).toString();
    }
}

