/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.hiero.consensus.event.FutureEventBuffer;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.event.creator.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.EventCreator;
import org.hiero.consensus.event.creator.impl.rules.AggregateEventCreationRules;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.event.creator.impl.rules.MaximumRateRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformHealthRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformStatusRule;
import org.hiero.consensus.event.creator.impl.rules.QuiescenceRule;
import org.hiero.consensus.event.creator.impl.rules.SyncLagCalculator;
import org.hiero.consensus.event.creator.impl.rules.SyncLagRule;
import org.hiero.consensus.metrics.extensions.PhaseTimer;
import org.hiero.consensus.metrics.extensions.PhaseTimerBuilder;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

public class DefaultEventCreationManager
implements EventCreationManager {
    private static final DoubleGauge.Config SYNC_ROUND_LAG_METRIC_CONFIG = new DoubleGauge.Config("platform", "syncRoundLag").withDescription("How many rounds on average are we lagging behind peers").withFormat("%,.3f");
    private final EventCreator creator;
    private final EventCreationRule eventCreationRules;
    private final PhaseTimer<EventCreationStatus> phase;
    private Duration unhealthyDuration = Duration.ZERO;
    private final FutureEventBuffer futureEventBuffer;
    private final QuiescenceRule quiescenceRule;
    private final PlatformStatusRule platformStatusRule;
    private final DoubleGauge syncLagBehind;
    private final SyncLagCalculator syncLagCalculator;

    public DefaultEventCreationManager(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SignatureTransactionCheck signatureTransactionCheck, @NonNull EventCreator eventCreator, @NonNull Roster roster, @NonNull NodeId selfId) {
        this.creator = Objects.requireNonNull(eventCreator);
        this.syncLagCalculator = new SyncLagCalculator(selfId, roster);
        EventCreationConfig config = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        this.platformStatusRule = new PlatformStatusRule(signatureTransactionCheck);
        this.quiescenceRule = new QuiescenceRule();
        ArrayList<EventCreationRule> rules = new ArrayList<EventCreationRule>();
        rules.add(new MaximumRateRule(configuration, time));
        rules.add(this.platformStatusRule);
        rules.add(new PlatformHealthRule(config.maximumPermissibleUnhealthyDuration(), this::getUnhealthyDuration));
        rules.add(new SyncLagRule(config.maxAllowedSyncLag(), this::getSyncRoundLag));
        rules.add(this.quiescenceRule);
        this.eventCreationRules = AggregateEventCreationRules.of(rules);
        this.futureEventBuffer = new FutureEventBuffer(metrics, FutureEventBufferingOption.EVENT_BIRTH_ROUND, "eventCreator");
        this.phase = new PhaseTimerBuilder(metrics, time, "platform", EventCreationStatus.class).enableFractionalMetrics().setInitialPhase((Enum)EventCreationStatus.IDLE).setMetricsNamePrefix("eventCreation").build();
        this.syncLagBehind = (DoubleGauge)metrics.getOrCreate((MetricConfig)SYNC_ROUND_LAG_METRIC_CONFIG);
    }

    @Override
    @Nullable
    public PlatformEvent maybeCreateEvent() {
        if (!this.eventCreationRules.isEventCreationPermitted()) {
            this.phase.activatePhase((Enum)this.eventCreationRules.getEventCreationStatus());
            return null;
        }
        this.phase.activatePhase((Enum)EventCreationStatus.ATTEMPTING_CREATION);
        PlatformEvent newEvent = this.creator.maybeCreateEvent();
        if (newEvent == null) {
            this.phase.activatePhase((Enum)EventCreationStatus.NO_ELIGIBLE_PARENTS);
        } else {
            this.eventCreationRules.eventWasCreated();
            this.phase.activatePhase((Enum)EventCreationStatus.RATE_LIMITED);
        }
        return newEvent;
    }

    @Override
    public void registerEvent(@NonNull PlatformEvent event) {
        PlatformEvent nonFutureEvent = this.futureEventBuffer.addEvent(event);
        if (nonFutureEvent != null) {
            this.creator.registerEvent(event);
        }
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.creator.setEventWindow(eventWindow);
        this.futureEventBuffer.updateEventWindow(eventWindow).forEach(this.creator::registerEvent);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        Objects.requireNonNull(quiescenceCommand);
        this.quiescenceRule.quiescenceCommand(quiescenceCommand);
        this.creator.quiescenceCommand(quiescenceCommand);
    }

    @Override
    public void clear() {
        this.creator.clear();
        this.phase.activatePhase((Enum)EventCreationStatus.IDLE);
        this.futureEventBuffer.clear();
        EventWindow eventWindow = EventWindow.getGenesisEventWindow();
        this.futureEventBuffer.updateEventWindow(eventWindow);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatusRule.setPlatformStatus(Objects.requireNonNull(platformStatus));
    }

    @Override
    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.unhealthyDuration = Objects.requireNonNull(duration);
    }

    @Override
    public void reportSyncProgress(@NonNull SyncProgress syncProgress) {
        long diff = syncProgress.peerWindow().getPendingConsensusRound() - syncProgress.localWindow().getPendingConsensusRound();
        this.syncLagCalculator.reportSyncLag(syncProgress.peerId(), diff);
    }

    private Duration getUnhealthyDuration() {
        return this.unhealthyDuration;
    }

    public double getSyncRoundLag() {
        double clampedMedianLag = this.syncLagCalculator.getSyncRoundLag();
        this.syncLagBehind.set(clampedMedianLag);
        return clampedMedianLag;
    }
}

