/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.report;

import com.swirlds.base.formatting.HorizontalAlignment;
import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.base.formatting.TextEffect;
import com.swirlds.base.formatting.TextHistogram;
import com.swirlds.base.formatting.TextTable;
import com.swirlds.base.formatting.UnitFormatter;
import com.swirlds.base.units.DataUnit;
import com.swirlds.base.units.Unit;
import com.swirlds.platform.event.report.EventStreamInfo;
import java.time.Duration;
import java.util.List;
import org.hiero.consensus.model.event.CesEvent;

public record EventStreamReport(List<EventStreamInfo> granularInfo, EventStreamInfo summary) {
    private static final int HASH_STRING_LENGTH = 12;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("--- Event Count ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::eventCount).setTimestampExtractor(EventStreamInfo::start).render(sb);
        sb.append("\n");
        sb.append("--- Rounds ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::roundCount).setTimestampExtractor(EventStreamInfo::start).render(sb);
        sb.append("\n");
        sb.append("--- Application Transaction Count ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::applicationTransactionCount).setTimestampExtractor(EventStreamInfo::start).render(sb);
        sb.append("\n");
        sb.append("--- File Count ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::fileCount).setTimestampExtractor(EventStreamInfo::start).render(sb);
        sb.append("\n");
        sb.append("--- Damaged File Count ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::damagedFileCount).setTimestampExtractor(EventStreamInfo::start).render(sb);
        sb.append("\n");
        sb.append("--- Byte Count ---\n");
        new TextHistogram(this.granularInfo, EventStreamInfo::byteCount).setTimestampExtractor(EventStreamInfo::start).setValueUnit((Unit)DataUnit.UNIT_BYTES).render(sb);
        sb.append("\n");
        CesEvent firstEvent = this.summary.firstEvent();
        CesEvent lastEvent = this.summary.lastEvent();
        new TextTable().setTitle("First/Last Event Info").addTitleEffects(new TextEffect[]{TextEffect.BRIGHT_CYAN}).addColumnEffects(0, new TextEffect[]{TextEffect.BRIGHT_RED}).addRowEffects(0, new TextEffect[]{TextEffect.BRIGHT_RED}).setRowHorizontalAlignment(0, HorizontalAlignment.ALIGNED_CENTER).addRow(new Object[]{"", "first event", "last event"}).addRow(new Object[]{"round", StringFormattingUtils.commaSeparatedNumber((long)firstEvent.getRoundReceived()), StringFormattingUtils.commaSeparatedNumber((long)lastEvent.getRoundReceived())}).addRow(new Object[]{"timestamp", firstEvent.getPlatformEvent().getConsensusTimestamp(), lastEvent.getPlatformEvent().getConsensusTimestamp()}).addRow(new Object[]{"hash", firstEvent.getHash().toHex(12), lastEvent.getHash().toHex(12)}).addRow(new Object[]{"running hash", firstEvent.getRunningHash().getHash().toHex(12), lastEvent.getRunningHash().getHash().toHex(12)}).addRow(new Object[]{"consensus order", StringFormattingUtils.commaSeparatedNumber((long)firstEvent.getPlatformEvent().getConsensusOrder()), StringFormattingUtils.commaSeparatedNumber((long)lastEvent.getPlatformEvent().getConsensusOrder())}).addRow(new Object[]{"creator ID", firstEvent.getPlatformEvent().getCreatorId(), lastEvent.getPlatformEvent().getCreatorId()}).addRow(new Object[]{"last in round", firstEvent.isLastInRoundReceived() ? "yes" : "no", lastEvent.isLastInRoundReceived() ? "yes" : "no"}).addRow(new Object[]{"transaction count", StringFormattingUtils.commaSeparatedNumber((long)firstEvent.getPlatformEvent().getTransactionCount()), StringFormattingUtils.commaSeparatedNumber((long)lastEvent.getPlatformEvent().getTransactionCount())}).render(sb);
        sb.append("\n\n");
        new TextTable().setBordersEnabled(false).addRow(new Object[]{TextEffect.BRIGHT_RED.apply("first event full hash"), firstEvent.getHash().toString()}).addRow(new Object[]{TextEffect.BRIGHT_YELLOW.apply("first event full running hash"), firstEvent.getRunningHash().getHash().toString()}).addRow(new Object[]{TextEffect.BRIGHT_RED.apply("last event full hash"), lastEvent.getHash().toString()}).addRow(new Object[]{TextEffect.BRIGHT_YELLOW.apply("last event full running hash"), lastEvent.getRunningHash().getHash().toString()}).render(sb);
        sb.append("\n\n");
        new TextTable().setTitle(TextEffect.BRIGHT_CYAN.apply("Stream Info")).addTitleEffects(new TextEffect[]{TextEffect.BRIGHT_CYAN}).addColumnEffects(0, new TextEffect[]{TextEffect.BRIGHT_RED}).addRow(new Object[]{"rounds", StringFormattingUtils.commaSeparatedNumber((long)this.summary.roundCount())}).addRow(new Object[]{"time", StringFormattingUtils.commaSeparatedNumber((long)Duration.between(this.summary.start(), this.summary.end()).toSeconds()) + "s"}).addRow(new Object[]{"events", StringFormattingUtils.commaSeparatedNumber((long)this.summary.eventCount())}).addRow(new Object[]{"application transactions", StringFormattingUtils.commaSeparatedNumber((long)this.summary.applicationTransactionCount())}).addRow(new Object[]{"files", StringFormattingUtils.commaSeparatedNumber((long)this.summary.fileCount())}).addRow(new Object[]{"bytes", new UnitFormatter(this.summary.byteCount(), (Unit)DataUnit.UNIT_BYTES).render()}).addRow(new Object[]{"damaged file count", StringFormattingUtils.commaSeparatedNumber((long)this.summary.damagedFileCount())}).render(sb);
        return sb.toString();
    }
}

