/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class Services {
    private Services() {
    }

    public static void registry(ServiceRegistry registry) {
        GlobalServiceRegistry.registry(registry);
    }

    @SafeVarargs
    public static <T> void set(Class<T> contract, T ... instances) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instances);
        for (T instance : instances) {
            Objects.requireNonNull(instance, "All instances must be non-null");
        }
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.set(contract, instances);
        }
    }

    public static <T> void setQualified(Class<T> contract, T instance, Qualifier ... qualifiers) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instance);
        Objects.requireNonNull(qualifiers);
        if (qualifiers.length == 0) {
            Services.set(contract, instance);
            return;
        }
        for (Qualifier qualifier : qualifiers) {
            Objects.requireNonNull(qualifier, "All qualifiers must be non-null");
        }
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.setQualified(contract, instance, Set.of(qualifiers));
        }
    }

    public static <T> void setNamed(Class<T> contract, T instance, String name) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instance);
        Objects.requireNonNull(name);
        Services.setQualified(contract, instance, Qualifier.createNamed(name));
    }

    public static <T> void add(Class<T> contract, double weight, T instance) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(instance);
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.add(contract, weight, instance);
        }
    }

    public static void add(ServiceDescriptor<?> descriptor) {
        Objects.requireNonNull(descriptor);
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        if (registry instanceof CoreServiceRegistry) {
            CoreServiceRegistry csr = (CoreServiceRegistry)registry;
            csr.add(descriptor);
        }
    }

    public static <T> T get(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().get(contract);
    }

    public static <T> T getNamed(Class<T> contract, String name) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(name);
        return Services.get(contract, Qualifier.createNamed(name));
    }

    public static <T> T get(Class<T> contract, Qualifier ... qualifiers) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(qualifiers);
        return GlobalServiceRegistry.registry().get(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public static <T> T get(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().get(contract);
    }

    public static <T> T getNamed(TypeName contract, String name) {
        return Services.get(contract, Qualifier.createNamed(name));
    }

    public static <T> T get(TypeName contract, Qualifier ... qualifiers) {
        return GlobalServiceRegistry.registry().get(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public static <T> List<T> all(Class<T> contract, Qualifier ... qualifiers) {
        return GlobalServiceRegistry.registry().all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public static <T> List<T> all(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().all(contract);
    }

    public static <T> List<T> all(TypeName contract, Qualifier ... qualifiers) {
        return GlobalServiceRegistry.registry().all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public static <T> List<T> all(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().all(contract);
    }

    public static <T> Optional<T> first(Class<T> contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().first(contract);
    }

    public static <T> Optional<T> firstNamed(Class<T> contract, String name) {
        return Services.first(contract, Qualifier.createNamed(name));
    }

    public static <T> Optional<T> first(Class<T> contract, Qualifier ... qualifiers) {
        return GlobalServiceRegistry.registry().first(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public static <T> Optional<T> first(TypeName contract) {
        Objects.requireNonNull(contract);
        return GlobalServiceRegistry.registry().first(contract);
    }

    public static <T> Optional<T> firstNamed(TypeName contract, String name) {
        return Services.first(contract, Qualifier.createNamed(name));
    }

    public static <T> Optional<T> first(TypeName contract, Qualifier ... qualifiers) {
        return GlobalServiceRegistry.registry().first(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }
}

