/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.addressbook;

import com.hedera.hapi.node.addressbook.codec.RegisteredServiceEndpointJsonCodec;
import com.hedera.hapi.node.addressbook.codec.RegisteredServiceEndpointProtoCodec;
import com.hedera.hapi.node.addressbook.schema.RegisteredServiceEndpointSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RegisteredServiceEndpoint {
    public static final Codec<RegisteredServiceEndpoint> PROTOBUF = new RegisteredServiceEndpointProtoCodec();
    public static final JsonCodec<RegisteredServiceEndpoint> JSON = new RegisteredServiceEndpointJsonCodec();
    public static final RegisteredServiceEndpoint DEFAULT = RegisteredServiceEndpoint.newBuilder().build();
    private final OneOf<AddressOneOfType> address;
    private final int port;
    private final boolean requiresTls;
    private final OneOf<EndpointTypeOneOfType> endpointType;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public RegisteredServiceEndpoint(OneOf<AddressOneOfType> address, int port, boolean requiresTls, OneOf<EndpointTypeOneOfType> endpointType) {
        this.$unknownFields = null;
        if (address == null) {
            throw new NullPointerException("Parameter 'address' must be supplied and can not be null");
        }
        this.address = address;
        this.port = port;
        this.requiresTls = requiresTls;
        if (endpointType == null) {
            throw new NullPointerException("Parameter 'endpointType' must be supplied and can not be null");
        }
        this.endpointType = endpointType;
    }

    public RegisteredServiceEndpoint(OneOf<AddressOneOfType> address, int port, boolean requiresTls, OneOf<EndpointTypeOneOfType> endpointType, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (address == null) {
            throw new NullPointerException("Parameter 'address' must be supplied and can not be null");
        }
        this.address = address;
        this.port = port;
        this.requiresTls = requiresTls;
        if (endpointType == null) {
            throw new NullPointerException("Parameter 'endpointType' must be supplied and can not be null");
        }
        this.endpointType = endpointType;
    }

    public OneOf<AddressOneOfType> address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    public boolean requiresTls() {
        return this.requiresTls;
    }

    public OneOf<EndpointTypeOneOfType> endpointType() {
        return this.endpointType;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.address.kind() == AddressOneOfType.IP_ADDRESS) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)RegisteredServiceEndpointSchema.IP_ADDRESS, (RandomAccessData)((RandomAccessData)this.address.as()), (boolean)true);
            }
            if (this.address.kind() == AddressOneOfType.DOMAIN_NAME) {
                _size += ProtoWriterTools.sizeOfString((FieldDefinition)RegisteredServiceEndpointSchema.DOMAIN_NAME, (String)((String)this.address.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)RegisteredServiceEndpointSchema.PORT, (int)this.port, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)RegisteredServiceEndpointSchema.REQUIRES_TLS, (boolean)this.requiresTls, (boolean)true);
            if (this.endpointType.kind() == EndpointTypeOneOfType.BLOCK_NODE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RegisteredServiceEndpointSchema.BLOCK_NODE, (Object)((BlockNodeEndpoint)this.endpointType.as()), BlockNodeEndpoint.PROTOBUF);
            }
            if (this.endpointType.kind() == EndpointTypeOneOfType.MIRROR_NODE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RegisteredServiceEndpointSchema.MIRROR_NODE, (Object)((MirrorNodeEndpoint)this.endpointType.as()), MirrorNodeEndpoint.PROTOBUF);
            }
            if (this.endpointType.kind() == EndpointTypeOneOfType.RPC_RELAY) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RegisteredServiceEndpointSchema.RPC_RELAY, (Object)((RpcRelayEndpoint)this.endpointType.as()), RpcRelayEndpoint.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.address != null && !this.address.equals(RegisteredServiceEndpoint.DEFAULT.address)) {
                result = 31 * result + this.address.hashCode();
            }
            if (this.port != RegisteredServiceEndpoint.DEFAULT.port) {
                result = 31 * result + Integer.hashCode(this.port);
            }
            if (this.requiresTls != RegisteredServiceEndpoint.DEFAULT.requiresTls) {
                result = 31 * result + Boolean.hashCode(this.requiresTls);
            }
            if (this.endpointType != null && !this.endpointType.equals(RegisteredServiceEndpoint.DEFAULT.endpointType)) {
                result = 31 * result + this.endpointType.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        RegisteredServiceEndpoint thatObj = (RegisteredServiceEndpoint)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.address == null && thatObj.address != null) {
            return false;
        }
        if (this.address != null && !this.address.equals(thatObj.address)) {
            return false;
        }
        if (this.port != thatObj.port) {
            return false;
        }
        if (this.requiresTls != thatObj.requiresTls) {
            return false;
        }
        if (this.endpointType == null && thatObj.endpointType != null) {
            return false;
        }
        if (this.endpointType != null && !this.endpointType.equals(thatObj.endpointType)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "RegisteredServiceEndpoint[address=" + String.valueOf(this.address) + ", port=" + this.port + ", requiresTls=" + this.requiresTls + ", endpointType=" + String.valueOf(this.endpointType) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Bytes ipAddress() {
        return this.address.kind() == AddressOneOfType.IP_ADDRESS ? (Bytes)this.address.value() : null;
    }

    public boolean hasIpAddress() {
        return this.address.kind() == AddressOneOfType.IP_ADDRESS;
    }

    public Bytes ipAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasIpAddress() ? this.ipAddress() : defaultValue;
    }

    @NonNull
    public Bytes ipAddressOrThrow() {
        return Objects.requireNonNull(this.ipAddress(), "Field ipAddress is null");
    }

    @Nullable
    public String domainName() {
        return this.address.kind() == AddressOneOfType.DOMAIN_NAME ? (String)this.address.value() : null;
    }

    public boolean hasDomainName() {
        return this.address.kind() == AddressOneOfType.DOMAIN_NAME;
    }

    public String domainNameOrElse(@NonNull String defaultValue) {
        return this.hasDomainName() ? this.domainName() : defaultValue;
    }

    @NonNull
    public String domainNameOrThrow() {
        return Objects.requireNonNull(this.domainName(), "Field domainName is null");
    }

    @Nullable
    public BlockNodeEndpoint blockNode() {
        return this.endpointType.kind() == EndpointTypeOneOfType.BLOCK_NODE ? (BlockNodeEndpoint)this.endpointType.value() : null;
    }

    public boolean hasBlockNode() {
        return this.endpointType.kind() == EndpointTypeOneOfType.BLOCK_NODE;
    }

    public BlockNodeEndpoint blockNodeOrElse(@NonNull BlockNodeEndpoint defaultValue) {
        return this.hasBlockNode() ? this.blockNode() : defaultValue;
    }

    @NonNull
    public BlockNodeEndpoint blockNodeOrThrow() {
        return Objects.requireNonNull(this.blockNode(), "Field blockNode is null");
    }

    @Nullable
    public MirrorNodeEndpoint mirrorNode() {
        return this.endpointType.kind() == EndpointTypeOneOfType.MIRROR_NODE ? (MirrorNodeEndpoint)this.endpointType.value() : null;
    }

    public boolean hasMirrorNode() {
        return this.endpointType.kind() == EndpointTypeOneOfType.MIRROR_NODE;
    }

    public MirrorNodeEndpoint mirrorNodeOrElse(@NonNull MirrorNodeEndpoint defaultValue) {
        return this.hasMirrorNode() ? this.mirrorNode() : defaultValue;
    }

    @NonNull
    public MirrorNodeEndpoint mirrorNodeOrThrow() {
        return Objects.requireNonNull(this.mirrorNode(), "Field mirrorNode is null");
    }

    @Nullable
    public RpcRelayEndpoint rpcRelay() {
        return this.endpointType.kind() == EndpointTypeOneOfType.RPC_RELAY ? (RpcRelayEndpoint)this.endpointType.value() : null;
    }

    public boolean hasRpcRelay() {
        return this.endpointType.kind() == EndpointTypeOneOfType.RPC_RELAY;
    }

    public RpcRelayEndpoint rpcRelayOrElse(@NonNull RpcRelayEndpoint defaultValue) {
        return this.hasRpcRelay() ? this.rpcRelay() : defaultValue;
    }

    @NonNull
    public RpcRelayEndpoint rpcRelayOrThrow() {
        return Objects.requireNonNull(this.rpcRelay(), "Field rpcRelay is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.address, this.port, this.requiresTls, this.endpointType, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum AddressOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        IP_ADDRESS(1, "ip_address"),
        DOMAIN_NAME(2, "domain_name");

        private final int protoOrdinal;
        private final String protoName;

        private AddressOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static AddressOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> IP_ADDRESS;
                case 2 -> DOMAIN_NAME;
                default -> UNSET;
            };
        }

        public static AddressOneOfType fromString(String name) {
            return switch (name) {
                case "ip_address", "IP_ADDRESS" -> IP_ADDRESS;
                case "domain_name", "DOMAIN_NAME" -> DOMAIN_NAME;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static AddressOneOfType fromObject(Object obj) {
            if (obj == null) {
                return AddressOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof AddressOneOfType) {
                AddressOneOfType pbjEnum = (AddressOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<AddressOneOfType> fromObjects(List<?> list) {
            return list.stream().map(AddressOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof AddressOneOfType) {
                AddressOneOfType pbjEnum = (AddressOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither AddressOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(AddressOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof AddressOneOfType) {
                AddressOneOfType e1 = (AddressOneOfType)((Object)o1);
                if (o2 instanceof AddressOneOfType) {
                    AddressOneOfType e2 = (AddressOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof AddressOneOfType) {
                AddressOneOfType e1 = (AddressOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither AddressOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof AddressOneOfType) {
                AddressOneOfType e2 = (AddressOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither AddressOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static enum EndpointTypeOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        BLOCK_NODE(5, "block_node"),
        MIRROR_NODE(6, "mirror_node"),
        RPC_RELAY(7, "rpc_relay");

        private final int protoOrdinal;
        private final String protoName;

        private EndpointTypeOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static EndpointTypeOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 5 -> BLOCK_NODE;
                case 6 -> MIRROR_NODE;
                case 7 -> RPC_RELAY;
                default -> UNSET;
            };
        }

        public static EndpointTypeOneOfType fromString(String name) {
            return switch (name) {
                case "block_node", "BLOCK_NODE" -> BLOCK_NODE;
                case "mirror_node", "MIRROR_NODE" -> MIRROR_NODE;
                case "rpc_relay", "RPC_RELAY" -> RPC_RELAY;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static EndpointTypeOneOfType fromObject(Object obj) {
            if (obj == null) {
                return EndpointTypeOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof EndpointTypeOneOfType) {
                EndpointTypeOneOfType pbjEnum = (EndpointTypeOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<EndpointTypeOneOfType> fromObjects(List<?> list) {
            return list.stream().map(EndpointTypeOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof EndpointTypeOneOfType) {
                EndpointTypeOneOfType pbjEnum = (EndpointTypeOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither EndpointTypeOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(EndpointTypeOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof EndpointTypeOneOfType) {
                EndpointTypeOneOfType e1 = (EndpointTypeOneOfType)((Object)o1);
                if (o2 instanceof EndpointTypeOneOfType) {
                    EndpointTypeOneOfType e2 = (EndpointTypeOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof EndpointTypeOneOfType) {
                EndpointTypeOneOfType e1 = (EndpointTypeOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither EndpointTypeOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof EndpointTypeOneOfType) {
                EndpointTypeOneOfType e2 = (EndpointTypeOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither EndpointTypeOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class BlockNodeEndpoint {
        public static final Codec<BlockNodeEndpoint> PROTOBUF = new RegisteredServiceEndpointProtoCodec.BlockNodeEndpointProtoCodec();
        public static final JsonCodec<BlockNodeEndpoint> JSON = new RegisteredServiceEndpointJsonCodec.BlockNodeEndpointJsonCodec();
        public static final BlockNodeEndpoint DEFAULT = BlockNodeEndpoint.newBuilder().build();
        private final Object endpointApi;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public BlockNodeEndpoint(BlockNodeApi endpointApi) {
            this.$unknownFields = null;
            this.endpointApi = endpointApi;
        }

        public BlockNodeEndpoint(Object endpointApi) {
            this.$unknownFields = null;
            this.endpointApi = endpointApi;
        }

        public BlockNodeEndpoint(BlockNodeApi endpointApi, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.endpointApi = endpointApi;
        }

        public BlockNodeEndpoint(Object endpointApi, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.endpointApi = endpointApi;
        }

        public BlockNodeApi endpointApi() {
            return BlockNodeApi.fromObject(this.endpointApi);
        }

        public int endpointApiProtoOrdinal() {
            return BlockNodeApi.toProtoOrdinal(this.endpointApi);
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)RegisteredServiceEndpointSchema.BlockNodeEndpointSchema.ENDPOINT_API, (Object)this.endpointApi);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.endpointApi != null && !this.endpointApi.equals(BlockNodeEndpoint.DEFAULT.endpointApi)) {
                    result = 31 * result + Integer.hashCode(EnumWithProtoMetadata.protoOrdinal((Object)this.endpointApi));
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            BlockNodeEndpoint thatObj = (BlockNodeEndpoint)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.endpointApi == null && thatObj.endpointApi != null) {
                return false;
            }
            if (this.endpointApi != null && !this.endpointApi.equals(thatObj.endpointApi)) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "BlockNodeEndpoint[endpointApi=" + String.valueOf(this.endpointApi) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.endpointApi, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static enum BlockNodeApi implements EnumWithProtoMetadata
        {
            OTHER(0, "OTHER"),
            STATUS(1, "STATUS"),
            PUBLISH(2, "PUBLISH"),
            SUBSCRIBE_STREAM(3, "SUBSCRIBE_STREAM"),
            STATE_PROOF(4, "STATE_PROOF"),
            UNRECOGNIZED(-1, "UNRECOGNIZED");

            private final int protoOrdinal;
            private final String protoName;

            private BlockNodeApi(int protoOrdinal, String protoName) {
                this.protoOrdinal = protoOrdinal;
                this.protoName = protoName;
            }

            public int protoOrdinal() {
                return this.protoOrdinal;
            }

            public String protoName() {
                return this.protoName;
            }

            public static BlockNodeApi fromProtobufOrdinal(int ordinal) {
                return switch (ordinal) {
                    case 0 -> OTHER;
                    case 1 -> STATUS;
                    case 2 -> PUBLISH;
                    case 3 -> SUBSCRIBE_STREAM;
                    case 4 -> STATE_PROOF;
                    default -> UNRECOGNIZED;
                };
            }

            public static BlockNodeApi fromString(String name) {
                return switch (name) {
                    case "OTHER" -> OTHER;
                    case "STATUS" -> STATUS;
                    case "PUBLISH" -> PUBLISH;
                    case "SUBSCRIBE_STREAM" -> SUBSCRIBE_STREAM;
                    case "STATE_PROOF" -> STATE_PROOF;
                    default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
                };
            }

            public static BlockNodeApi fromObject(Object obj) {
                if (obj == null) {
                    return BlockNodeApi.fromProtobufOrdinal(0);
                }
                if (obj instanceof BlockNodeApi) {
                    BlockNodeApi pbjEnum = (BlockNodeApi)((Object)obj);
                    return pbjEnum;
                }
                return UNRECOGNIZED;
            }

            public static List<BlockNodeApi> fromObjects(List<?> list) {
                return list.stream().map(BlockNodeApi::fromObject).toList();
            }

            public static int toProtoOrdinal(Object obj) {
                if (obj instanceof BlockNodeApi) {
                    BlockNodeApi pbjEnum = (BlockNodeApi)((Object)obj);
                    return pbjEnum.protoOrdinal();
                }
                if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    return i;
                }
                throw new IllegalArgumentException("Neither BlockNodeApi, nor Integer, but: " + obj.getClass().getName());
            }

            public static List<Integer> toProtoOrdinals(List<?> list) {
                return list.stream().map(BlockNodeApi::toProtoOrdinal).toList();
            }

            public static int compare(Object o1, Object o2) {
                int i2;
                int i1;
                if (o1 instanceof BlockNodeApi) {
                    BlockNodeApi e1 = (BlockNodeApi)((Object)o1);
                    if (o2 instanceof BlockNodeApi) {
                        BlockNodeApi e2 = (BlockNodeApi)((Object)o2);
                        return e1.compareTo(e2);
                    }
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1 instanceof BlockNodeApi) {
                    BlockNodeApi e1 = (BlockNodeApi)((Object)o1);
                    i1 = e1.protoOrdinal();
                } else if (o1 instanceof Integer) {
                    Integer ii1 = (Integer)o1;
                    i1 = ii1;
                } else {
                    throw new IllegalArgumentException("o1 is neither BlockNodeApi, nor Integer. It's: " + o1.getClass().getName());
                }
                if (o2 instanceof BlockNodeApi) {
                    BlockNodeApi e2 = (BlockNodeApi)((Object)o2);
                    i2 = e2.protoOrdinal();
                } else if (o2 instanceof Integer) {
                    Integer ii2 = (Integer)o2;
                    i2 = ii2;
                } else {
                    throw new IllegalArgumentException("o2 is neither BlockNodeApi, nor Integer. It's: " + o2.getClass().getName());
                }
                return Integer.compare(i1, i2);
            }
        }

        public static final class Builder {
            private Object endpointApi = BlockNodeApi.fromProtobufOrdinal(0);
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(BlockNodeApi endpointApi) {
                this.$unknownFields = null;
                this.endpointApi = endpointApi;
            }

            public Builder(Object endpointApi) {
                this.$unknownFields = null;
                this.endpointApi = endpointApi;
            }

            public Builder(BlockNodeApi endpointApi, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.endpointApi = endpointApi;
            }

            public Builder(Object endpointApi, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.endpointApi = endpointApi;
            }

            public BlockNodeEndpoint build() {
                return new BlockNodeEndpoint(this.endpointApi);
            }

            public Builder endpointApi(BlockNodeApi endpointApi) {
                this.endpointApi = endpointApi;
                return this;
            }

            public BlockNodeApi endpointApi() {
                return BlockNodeApi.fromObject(this.endpointApi);
            }

            public int endpointApiProtoOrdinal() {
                return BlockNodeApi.toProtoOrdinal(this.endpointApi);
            }
        }
    }

    public static final class MirrorNodeEndpoint {
        public static final Codec<MirrorNodeEndpoint> PROTOBUF = new RegisteredServiceEndpointProtoCodec.MirrorNodeEndpointProtoCodec();
        public static final JsonCodec<MirrorNodeEndpoint> JSON = new RegisteredServiceEndpointJsonCodec.MirrorNodeEndpointJsonCodec();
        public static final MirrorNodeEndpoint DEFAULT = MirrorNodeEndpoint.newBuilder().build();
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public MirrorNodeEndpoint() {
            this.$unknownFields = null;
        }

        public MirrorNodeEndpoint(List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            MirrorNodeEndpoint thatObj = (MirrorNodeEndpoint)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "MirrorNodeEndpoint[" + ($ufstr == null ? "" : $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            }

            public MirrorNodeEndpoint build() {
                return new MirrorNodeEndpoint();
            }
        }
    }

    public static final class RpcRelayEndpoint {
        public static final Codec<RpcRelayEndpoint> PROTOBUF = new RegisteredServiceEndpointProtoCodec.RpcRelayEndpointProtoCodec();
        public static final JsonCodec<RpcRelayEndpoint> JSON = new RegisteredServiceEndpointJsonCodec.RpcRelayEndpointJsonCodec();
        public static final RpcRelayEndpoint DEFAULT = RpcRelayEndpoint.newBuilder().build();
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public RpcRelayEndpoint() {
            this.$unknownFields = null;
        }

        public RpcRelayEndpoint(List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            RpcRelayEndpoint thatObj = (RpcRelayEndpoint)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "RpcRelayEndpoint[" + ($ufstr == null ? "" : $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            }

            public RpcRelayEndpoint build() {
                return new RpcRelayEndpoint();
            }
        }
    }

    public static final class Builder {
        private OneOf<AddressOneOfType> address = RegisteredServiceEndpointProtoCodec.ADDRESS_UNSET;
        private int port = 0;
        private boolean requiresTls = false;
        private OneOf<EndpointTypeOneOfType> endpointType = RegisteredServiceEndpointProtoCodec.ENDPOINT_TYPE_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<AddressOneOfType> address, int port, boolean requiresTls, OneOf<EndpointTypeOneOfType> endpointType) {
            this.$unknownFields = null;
            this.address = address;
            this.port = port;
            this.requiresTls = requiresTls;
            this.endpointType = endpointType;
        }

        public Builder(OneOf<AddressOneOfType> address, int port, boolean requiresTls, OneOf<EndpointTypeOneOfType> endpointType, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.address = address;
            this.port = port;
            this.requiresTls = requiresTls;
            this.endpointType = endpointType;
        }

        public RegisteredServiceEndpoint build() {
            return new RegisteredServiceEndpoint(this.address, this.port, this.requiresTls, this.endpointType);
        }

        public void clearAddress() {
            this.address = RegisteredServiceEndpointProtoCodec.ADDRESS_UNSET;
        }

        public Builder ipAddress(@NonNull Bytes ipAddress) {
            this.address = new OneOf((Enum)AddressOneOfType.IP_ADDRESS, (Object)ipAddress);
            return this;
        }

        public Builder domainName(@NonNull String domainName) {
            this.address = new OneOf((Enum)AddressOneOfType.DOMAIN_NAME, (Object)domainName);
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder requiresTls(boolean requiresTls) {
            this.requiresTls = requiresTls;
            return this;
        }

        public void clearEndpointType() {
            this.endpointType = RegisteredServiceEndpointProtoCodec.ENDPOINT_TYPE_UNSET;
        }

        public Builder blockNode(@Nullable BlockNodeEndpoint blockNode) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.BLOCK_NODE, (Object)blockNode);
            return this;
        }

        public Builder blockNode(BlockNodeEndpoint.Builder builder) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.BLOCK_NODE, (Object)builder.build());
            return this;
        }

        public Builder mirrorNode(@Nullable MirrorNodeEndpoint mirrorNode) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.MIRROR_NODE, (Object)mirrorNode);
            return this;
        }

        public Builder mirrorNode(MirrorNodeEndpoint.Builder builder) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.MIRROR_NODE, (Object)builder.build());
            return this;
        }

        public Builder rpcRelay(@Nullable RpcRelayEndpoint rpcRelay) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.RPC_RELAY, (Object)rpcRelay);
            return this;
        }

        public Builder rpcRelay(RpcRelayEndpoint.Builder builder) {
            this.endpointType = new OneOf((Enum)EndpointTypeOneOfType.RPC_RELAY, (Object)builder.build());
            return this;
        }

        public OneOf<AddressOneOfType> address() {
            return this.address;
        }

        public int port() {
            return this.port;
        }

        public boolean requiresTls() {
            return this.requiresTls;
        }

        public OneOf<EndpointTypeOneOfType> endpointType() {
            return this.endpointType;
        }
    }
}

