/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.codec.NodeAddressJsonCodec;
import com.hedera.hapi.node.base.codec.NodeAddressProtoCodec;
import com.hedera.hapi.node.base.schema.NodeAddressSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class NodeAddress {
    public static final Codec<NodeAddress> PROTOBUF = new NodeAddressProtoCodec();
    public static final JsonCodec<NodeAddress> JSON = new NodeAddressJsonCodec();
    public static final NodeAddress DEFAULT = NodeAddress.newBuilder().build();
    @NonNull
    private final Bytes ipAddress;
    private final int portno;
    @NonNull
    private final Bytes memo;
    @NonNull
    private final String rsaPubKey;
    private final long nodeId;
    @Nullable
    private final AccountID nodeAccountId;
    @NonNull
    private final Bytes nodeCertHash;
    @NonNull
    private final List<ServiceEndpoint> serviceEndpoint;
    @NonNull
    private final String description;
    private final long stake;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public NodeAddress(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
        this.$unknownFields = null;
        this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
        this.portno = portno;
        this.memo = memo != null ? memo : Bytes.EMPTY;
        this.rsaPubKey = rsaPubKey != null ? rsaPubKey : "";
        this.nodeId = nodeId;
        this.nodeAccountId = nodeAccountId;
        this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.description = description != null ? description : "";
        this.stake = stake;
    }

    public NodeAddress(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
        this.portno = portno;
        this.memo = memo != null ? memo : Bytes.EMPTY;
        this.rsaPubKey = rsaPubKey != null ? rsaPubKey : "";
        this.nodeId = nodeId;
        this.nodeAccountId = nodeAccountId;
        this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.description = description != null ? description : "";
        this.stake = stake;
    }

    public Bytes ipAddress() {
        return this.ipAddress;
    }

    public int portno() {
        return this.portno;
    }

    public Bytes memo() {
        return this.memo;
    }

    public String rsaPubKey() {
        return this.rsaPubKey;
    }

    public long nodeId() {
        return this.nodeId;
    }

    public AccountID nodeAccountId() {
        return this.nodeAccountId;
    }

    public Bytes nodeCertHash() {
        return this.nodeCertHash;
    }

    public List<ServiceEndpoint> serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public String description() {
        return this.description;
    }

    public long stake() {
        return this.stake;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.IP_ADDRESS, (RandomAccessData)this.ipAddress, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)NodeAddressSchema.PORTNO, (int)this.portno, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.MEMO, (RandomAccessData)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)NodeAddressSchema.RSA_PUBKEY, (String)this.rsaPubKey, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeAddressSchema.NODE_ID, (long)this.nodeId, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeAddressSchema.NODE_ACCOUNT_ID, (Object)this.nodeAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.NODE_CERT_HASH, (RandomAccessData)this.nodeCertHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeAddressSchema.SERVICE_ENDPOINT, this.serviceEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)NodeAddressSchema.DESCRIPTION, (String)this.description, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeAddressSchema.STAKE, (long)this.stake, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<ServiceEndpoint> list$serviceEndpoint;
            int result = 1;
            if (this.ipAddress != null && !this.ipAddress.equals((Object)NodeAddress.DEFAULT.ipAddress)) {
                result = 31 * result + this.ipAddress.hashCode();
            }
            if (this.portno != NodeAddress.DEFAULT.portno) {
                result = 31 * result + Integer.hashCode(this.portno);
            }
            if (this.memo != null && !this.memo.equals((Object)NodeAddress.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.rsaPubKey != null && !this.rsaPubKey.equals(NodeAddress.DEFAULT.rsaPubKey)) {
                result = 31 * result + this.rsaPubKey.hashCode();
            }
            if (this.nodeId != NodeAddress.DEFAULT.nodeId) {
                result = 31 * result + Long.hashCode(this.nodeId);
            }
            if (this.nodeAccountId != null && !this.nodeAccountId.equals(NodeAddress.DEFAULT.nodeAccountId)) {
                result = 31 * result + this.nodeAccountId.hashCode();
            }
            if (this.nodeCertHash != null && !this.nodeCertHash.equals((Object)NodeAddress.DEFAULT.nodeCertHash)) {
                result = 31 * result + this.nodeCertHash.hashCode();
            }
            if ((list$serviceEndpoint = this.serviceEndpoint) != null) {
                for (ServiceEndpoint o : list$serviceEndpoint) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.description != null && !this.description.equals(NodeAddress.DEFAULT.description)) {
                result = 31 * result + this.description.hashCode();
            }
            if (this.stake != NodeAddress.DEFAULT.stake) {
                result = 31 * result + Long.hashCode(this.stake);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeAddress thatObj = (NodeAddress)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.ipAddress == null && thatObj.ipAddress != null) {
            return false;
        }
        if (this.ipAddress != null && !this.ipAddress.equals((Object)thatObj.ipAddress)) {
            return false;
        }
        if (this.portno != thatObj.portno) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals((Object)thatObj.memo)) {
            return false;
        }
        if (this.rsaPubKey == null && thatObj.rsaPubKey != null) {
            return false;
        }
        if (this.rsaPubKey != null && !this.rsaPubKey.equals(thatObj.rsaPubKey)) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.nodeAccountId == null && thatObj.nodeAccountId != null) {
            return false;
        }
        if (this.nodeAccountId != null && !this.nodeAccountId.equals(thatObj.nodeAccountId)) {
            return false;
        }
        if (this.nodeCertHash == null && thatObj.nodeCertHash != null) {
            return false;
        }
        if (this.nodeCertHash != null && !this.nodeCertHash.equals((Object)thatObj.nodeCertHash)) {
            return false;
        }
        if (this.serviceEndpoint == null && thatObj.serviceEndpoint != null) {
            return false;
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.equals(thatObj.serviceEndpoint)) {
            return false;
        }
        if (this.description == null && thatObj.description != null) {
            return false;
        }
        if (this.description != null && !this.description.equals(thatObj.description)) {
            return false;
        }
        if (this.stake != thatObj.stake) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "NodeAddress[ipAddress=" + String.valueOf(this.ipAddress) + ", portno=" + this.portno + ", memo=" + String.valueOf(this.memo) + ", rsaPubKey=" + this.rsaPubKey + ", nodeId=" + this.nodeId + ", nodeAccountId=" + String.valueOf(this.nodeAccountId) + ", nodeCertHash=" + String.valueOf(this.nodeCertHash) + ", serviceEndpoint=" + String.valueOf(this.serviceEndpoint) + ", description=" + this.description + ", stake=" + this.stake + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasNodeAccountId() {
        return this.nodeAccountId != null;
    }

    public AccountID nodeAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasNodeAccountId() ? this.nodeAccountId : defaultValue;
    }

    @NonNull
    public AccountID nodeAccountIdOrThrow() {
        return Objects.requireNonNull(this.nodeAccountId, "Field nodeAccountId is null");
    }

    public void ifNodeAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasNodeAccountId()) {
            ifPresent.accept(this.nodeAccountId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes ipAddress = Bytes.EMPTY;
        private int portno = 0;
        @NonNull
        private Bytes memo = Bytes.EMPTY;
        @NonNull
        private String rsaPubKey = "";
        private long nodeId = 0L;
        @Nullable
        private AccountID nodeAccountId = null;
        @NonNull
        private Bytes nodeCertHash = Bytes.EMPTY;
        @NonNull
        private List<ServiceEndpoint> serviceEndpoint = Collections.emptyList();
        @NonNull
        private String description = "";
        private long stake = 0L;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
            this.$unknownFields = null;
            this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
            this.portno = portno;
            this.memo = memo != null ? memo : Bytes.EMPTY;
            this.rsaPubKey = rsaPubKey != null ? rsaPubKey : "";
            this.nodeId = nodeId;
            this.nodeAccountId = nodeAccountId;
            this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.description = description != null ? description : "";
            this.stake = stake;
        }

        public Builder(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
            this.portno = portno;
            this.memo = memo != null ? memo : Bytes.EMPTY;
            this.rsaPubKey = rsaPubKey != null ? rsaPubKey : "";
            this.nodeId = nodeId;
            this.nodeAccountId = nodeAccountId;
            this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.description = description != null ? description : "";
            this.stake = stake;
        }

        public NodeAddress build() {
            return new NodeAddress(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake);
        }

        public Builder ipAddress(@NonNull Bytes ipAddress) {
            this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
            return this;
        }

        public Builder portno(int portno) {
            this.portno = portno;
            return this;
        }

        public Builder memo(@NonNull Bytes memo) {
            this.memo = memo != null ? memo : Bytes.EMPTY;
            return this;
        }

        public Builder rsaPubKey(@NonNull String rsaPubKey) {
            this.rsaPubKey = rsaPubKey != null ? rsaPubKey : "";
            return this;
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder nodeAccountId(@Nullable AccountID nodeAccountId) {
            this.nodeAccountId = nodeAccountId;
            return this;
        }

        public Builder nodeAccountId(AccountID.Builder builder) {
            this.nodeAccountId = builder.build();
            return this;
        }

        public Builder nodeCertHash(@NonNull Bytes nodeCertHash) {
            this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
            return this;
        }

        public Builder serviceEndpoint(@NonNull List<ServiceEndpoint> serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint != null ? serviceEndpoint : Collections.emptyList();
            return this;
        }

        public Builder serviceEndpoint(ServiceEndpoint ... values) {
            this.serviceEndpoint = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder description(@NonNull String description) {
            this.description = description != null ? description : "";
            return this;
        }

        public Builder stake(long stake) {
            this.stake = stake;
            return this;
        }

        public Bytes ipAddress() {
            return this.ipAddress;
        }

        public int portno() {
            return this.portno;
        }

        public Bytes memo() {
            return this.memo;
        }

        public String rsaPubKey() {
            return this.rsaPubKey;
        }

        public long nodeId() {
            return this.nodeId;
        }

        public AccountID nodeAccountId() {
            return this.nodeAccountId;
        }

        public Bytes nodeCertHash() {
            return this.nodeCertHash;
        }

        public List<ServiceEndpoint> serviceEndpoint() {
            return this.serviceEndpoint;
        }

        public String description() {
            return this.description;
        }

        public long stake() {
            return this.stake;
        }
    }
}

