/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class AddModOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult addModSuccess = new Operation.OperationResult(8L, null);

    public AddModOperation(GasCalculator gasCalculator) {
        super(8, "ADDMOD", 3, 1, gasCalculator, gasCalculator.getMidTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return AddModOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        Bytes value2 = frame.popStackItem();
        if (value2.isZero()) {
            frame.pushStackItem(Bytes.EMPTY);
        } else {
            BigInteger b0 = new BigInteger(1, value0.toArrayUnsafe());
            BigInteger b1 = new BigInteger(1, value1.toArrayUnsafe());
            BigInteger b2 = new BigInteger(1, value2.toArrayUnsafe());
            BigInteger result = b0.add(b1).mod(b2);
            Bytes resultBytes = Bytes.wrap((byte[])result.toByteArray());
            if (resultBytes.size() > 32) {
                resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
            }
            byte[] padding = new byte[32 - resultBytes.size()];
            Arrays.fill(padding, result.signum() < 0 ? (byte)-1 : 0);
            frame.pushStackItem(Bytes.concatenate((Bytes[])new Bytes[]{Bytes.wrap((byte[])padding), resultBytes}));
        }
        return addModSuccess;
    }
}

