/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CodeSizeOperation
extends AbstractFixedCostOperation {
    public CodeSizeOperation(GasCalculator gasCalculator) {
        super(56, "CODESIZE", 0, 1, gasCalculator, gasCalculator.getBaseTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        frame.pushStackItem(Words.intBytes(code.getSize()));
        return this.successResponse;
    }
}

