/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport;

import com.hedera.common.nativesupport.NativeBinary;
import com.hedera.common.nativesupport.OperatingSystem;
import java.nio.file.Path;
import java.util.Map;

public class NativeLibrary
extends NativeBinary {
    private static final Map<OperatingSystem, String> DEFAULT_LIB_EXTENSIONS = Map.of(OperatingSystem.WINDOWS, "dll", OperatingSystem.LINUX, "so", OperatingSystem.DARWIN, "dylib");
    private static final Map<OperatingSystem, String> DEFAULT_LIB_PREFIXES = Map.of(OperatingSystem.WINDOWS, "", OperatingSystem.LINUX, "lib", OperatingSystem.DARWIN, "lib");

    private NativeLibrary(String name, Map<OperatingSystem, String> libPrefixes, Map<OperatingSystem, String> libExtensions) {
        super(name, libPrefixes, libExtensions);
    }

    public static NativeLibrary withName(String name, Map<OperatingSystem, String> libPrefixes, Map<OperatingSystem, String> libExtensions) {
        return new NativeLibrary(name, libPrefixes, libExtensions);
    }

    public static NativeLibrary withName(String name) {
        return NativeLibrary.withName(name, DEFAULT_LIB_PREFIXES, DEFAULT_LIB_EXTENSIONS);
    }

    public void install(Class<?> c) {
        this.extract(c);
    }

    @Override
    protected Path extractUnchecked(Class<?> c) {
        Path path = super.extractUnchecked(c);
        System.load(path.toAbsolutePath().toString());
        return path;
    }
}

