/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.CryptoTransferHandler;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoTransferFeeCalculator
implements ServiceFeeCalculator {
    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_TRANSFER;
    }

    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_TRANSFER);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        CryptoTransferTransactionBody op = txnBody.cryptoTransferOrThrow();
        long numAccounts = this.countUniqueAccounts(op);
        this.addExtraFee(feeResult, serviceDef, Extra.ACCOUNTS, feeSchedule, numAccounts);
        CryptoTransferHandler.HookInfo hookInfo = CryptoTransferHandler.getHookInfo(op);
        if (hookInfo.numHookInvocations() > 0) {
            Configuration config = simpleFeeContext.feeContext().configuration();
            long effectiveGasLimit = Math.max(0L, Math.min((long)hookInfo.numHookInvocations() * ((ContractsConfig)config.getConfigData(ContractsConfig.class)).maxGasPerSec(), hookInfo.totalGasLimitOfHooks()));
            this.addExtraFee(feeResult, serviceDef, Extra.HOOK_EXECUTION, feeSchedule, hookInfo.numHookInvocations());
            this.addExtraFee(feeResult, serviceDef, Extra.GAS, feeSchedule, effectiveGasLimit);
        }
        if (simpleFeeContext.feeContext() != null) {
            ReadableTokenStore tokenStore = (ReadableTokenStore)simpleFeeContext.feeContext().readableStore(ReadableTokenStore.class);
            TokenCounts tokenCounts = this.analyzeTokenTransfers(op, tokenStore);
            Extra transferType = this.determineTransferType(tokenCounts);
            if (transferType != null) {
                this.addExtraFee(feeResult, serviceDef, transferType, feeSchedule, 1L);
            }
            long totalFungible = tokenCounts.standardFungible() + tokenCounts.customFeeFungible();
            long totalNft = tokenCounts.standardNft() + tokenCounts.customFeeNft();
            this.addExtraFee(feeResult, serviceDef, Extra.TOKEN_TYPES, feeSchedule, totalFungible + totalNft);
        } else {
            for (TokenTransferList ttl : op.tokenTransfers()) {
                int regular_count = ttl.transfers().size();
                int nft_count = ttl.nftTransfers().size();
                this.addExtraFee(feeResult, serviceDef, Extra.TOKEN_TYPES, feeSchedule, regular_count + nft_count);
            }
        }
    }

    @Nullable
    private Extra determineTransferType(@NonNull TokenCounts tokenCounts) {
        boolean hasAnyTokens;
        boolean hasCustomFeeTokens = tokenCounts.customFeeNft() > 0 || tokenCounts.customFeeFungible() > 0;
        boolean bl = hasAnyTokens = hasCustomFeeTokens || tokenCounts.standardNft() > 0 || tokenCounts.standardFungible() > 0;
        if (hasCustomFeeTokens) {
            return Extra.TOKEN_TRANSFER_BASE_CUSTOM_FEES;
        }
        if (hasAnyTokens) {
            return Extra.TOKEN_TRANSFER_BASE;
        }
        return null;
    }

    private long countUniqueAccounts(@NonNull CryptoTransferTransactionBody op) {
        HashSet accounts = new HashSet();
        op.transfersOrElse(TransferList.DEFAULT).accountAmounts().forEach(aa -> accounts.add(aa.accountIDOrThrow()));
        op.tokenTransfers().forEach(ttl -> {
            ttl.transfers().forEach(aa -> accounts.add(aa.accountIDOrThrow()));
            ttl.nftTransfers().forEach(nft -> {
                accounts.add(nft.senderAccountIDOrThrow());
                accounts.add(nft.receiverAccountIDOrThrow());
            });
        });
        return accounts.size();
    }

    private TokenCounts analyzeTokenTransfers(@NonNull CryptoTransferTransactionBody op, @NonNull ReadableTokenStore tokenStore) {
        int standardFungible = 0;
        int standardNft = 0;
        int customFeeFungible = 0;
        int customFeeNft = 0;
        for (TokenTransferList ttl : op.tokenTransfers()) {
            boolean isFungible;
            TokenID tokenId = ttl.tokenOrThrow();
            Token token = tokenStore.get(tokenId);
            if (token == null) continue;
            boolean hasCustomFees = !token.customFees().isEmpty();
            boolean bl = isFungible = token.tokenType() == TokenType.FUNGIBLE_COMMON;
            if (isFungible) {
                if (ttl.transfers().isEmpty()) continue;
                if (hasCustomFees) {
                    ++customFeeFungible;
                    continue;
                }
                ++standardFungible;
                continue;
            }
            int nftCount = ttl.nftTransfers().size();
            if (hasCustomFees) {
                customFeeNft += nftCount;
                continue;
            }
            standardNft += nftCount;
        }
        return new TokenCounts(standardFungible, standardNft, customFeeFungible, customFeeNft);
    }

    private record TokenCounts(int standardFungible, int standardNft, int customFeeFungible, int customFeeNft) {
    }
}

