/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.io.extendable.extensions;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.hiero.base.CompareTo;
import org.hiero.consensus.io.extendable.extensions.AbstractStreamExtension;

public class ExpiringStreamExtension
extends AbstractStreamExtension {
    private static final int DEFAULT_BYTES_PER_SAMPLE = 0x100000;
    private final Duration period;
    private final int bytesPerSample;
    private Instant start;
    private long bytesInCurrentSample;

    public ExpiringStreamExtension(Duration period) {
        this(period, 0x100000);
    }

    public ExpiringStreamExtension(Duration period, int bytesPerSample) {
        this.period = period;
        this.bytesPerSample = bytesPerSample;
        this.start = Instant.now();
    }

    public void reset() {
        this.bytesInCurrentSample = 0L;
        this.start = Instant.now();
    }

    private void checkIfExpired(int length) throws IOException {
        this.bytesInCurrentSample += (long)length;
        if (this.bytesInCurrentSample > (long)this.bytesPerSample) {
            Instant now = Instant.now();
            Duration elapsed = Duration.between(this.start, now);
            if (CompareTo.isGreaterThan((Comparable)elapsed, (Object)this.period)) {
                throw new IOException("stream has expired");
            }
            this.bytesInCurrentSample = 0L;
        }
    }

    @Override
    public void newByte(int aByte) throws IOException {
        this.checkIfExpired(1);
    }

    @Override
    public void newBytes(byte[] bytes, int offset, int length) throws IOException {
        this.checkIfExpired(length);
    }
}

