/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ContractCreateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ContractCreateTransactionBody op = txnBody.contractCreateInstanceOrThrow();
        Key adminKey = op.adminKey();
        long keys = adminKey != null ? FeeKeyUtils.countKeys((Key)adminKey) : 0L;
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONTRACT_CREATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
        if (!op.hookCreationDetails().isEmpty()) {
            this.addExtraFee(feeResult, serviceDef, Extra.HOOK_UPDATES, feeSchedule, op.hookCreationDetails().size());
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE;
    }
}

