/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;

public final class PendingAirdropsHelper {
    private static final int SENDER = 0;
    private static final int RECEIVER = 1;
    private static final int TOKEN = 2;
    private static final int SERIAL = 3;

    private PendingAirdropsHelper() {
    }

    @NonNull
    public static List<PendingAirdropId> decodePendingAirdrops(@NonNull HtsCallAttempt attempt, @NonNull Tuple[] transferList) {
        return Arrays.stream(transferList).map(transfer -> {
            Address senderAddress = (Address)transfer.get(0);
            Address receiverAddress = (Address)transfer.get(1);
            Address tokenAddress = (Address)transfer.get(2);
            long serial = (Long)transfer.get(3);
            AccountID senderId = attempt.addressIdConverter().convert(senderAddress);
            AccountID receiverId = attempt.addressIdConverter().convert(receiverAddress);
            TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress);
            Token token = attempt.enhancement().nativeOperations().getToken(tokenId);
            HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            if (token.tokenType().equals((Object)TokenType.FUNGIBLE_COMMON)) {
                return PendingAirdropsHelper.pendingFTAirdrop(senderId, receiverId, tokenId);
            }
            return PendingAirdropsHelper.pendingNFTAirdrop(senderId, receiverId, tokenId, serial);
        }).toList();
    }

    public static PendingAirdropId pendingFTAirdrop(@NonNull AccountID senderId, @NonNull AccountID receiverId, @NonNull TokenID tokenId) {
        return PendingAirdropId.newBuilder().senderId(senderId).receiverId(receiverId).fungibleTokenType(tokenId).build();
    }

    public static PendingAirdropId pendingNFTAirdrop(@NonNull AccountID senderId, @NonNull AccountID receiverId, @NonNull TokenID tokenId, long serial) {
        return PendingAirdropId.newBuilder().senderId(senderId).receiverId(receiverId).nonFungibleToken(NftID.newBuilder().tokenId(tokenId).serialNumber(serial)).build();
    }
}

