/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.CachedPoolParallelExecutor;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.config.ProtocolConfig;
import org.hiero.consensus.gossip.impl.gossip.Gossip;
import org.hiero.consensus.gossip.impl.gossip.Utilities;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowgraphSynchronizer;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;
import org.hiero.consensus.gossip.impl.network.PeerCommunication;
import org.hiero.consensus.gossip.impl.network.PeerInfo;
import org.hiero.consensus.gossip.impl.network.communication.handshake.VersionCompareHandshake;
import org.hiero.consensus.gossip.impl.network.protocol.HeartbeatProtocol;
import org.hiero.consensus.gossip.impl.network.protocol.Protocol;
import org.hiero.consensus.gossip.impl.network.protocol.ProtocolRunnable;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcProtocol;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.roster.RosterUtils;

public class SyncGossipModular
implements Gossip {
    private static final Logger logger = LogManager.getLogger(SyncGossipModular.class);
    private final PeerCommunication network;
    private final List<Protocol> protocols;
    private final RpcProtocol rpcProtocol;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final ShadowgraphSynchronizer synchronizer;
    private Consumer<PlatformEvent> receivedEventHandler;
    private Consumer<SyncProgress> syncProgressHandler;

    public SyncGossipModular(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull KeysAndCerts ownKeysAndCerts, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull SemanticVersion appVersion, @NonNull IntakeEventCounter intakeEventCounter, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull Protocol reconnectProtocol) {
        ShadowgraphSynchronizer rpcSynchronizer;
        List<PeerInfo> peers;
        RosterEntry selfEntry = RosterUtils.getRosterEntry((Roster)roster, (long)selfId.id());
        X509Certificate selfCert = RosterUtils.fetchGossipCaCertificate((RosterEntry)selfEntry);
        if (!CryptoUtils.checkCertificate((Certificate)selfCert)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "The gossip certificate for node {} is missing or invalid. This node will not connect to any peers.", (Object)selfId);
            peers = Collections.emptyList();
        } else {
            peers = Utilities.createPeerInfoList(roster, selfId);
        }
        PeerInfo selfPeer = Utilities.toPeerInfo(selfEntry);
        this.network = new PeerCommunication(configuration, metrics, time, peers, selfPeer, ownKeysAndCerts);
        this.fallenBehindMonitor = fallenBehindMonitor;
        ProtocolConfig protocolConfig = (ProtocolConfig)configuration.getConfigData(ProtocolConfig.class);
        int rosterSize = peers.size() + 1;
        SyncMetrics syncMetrics = new SyncMetrics(metrics, time, peers);
        this.synchronizer = rpcSynchronizer = new ShadowgraphSynchronizer(configuration, metrics, time, rosterSize, syncMetrics, intakeEventCounter, lag -> this.syncProgressHandler.accept((SyncProgress)lag));
        this.rpcProtocol = new RpcProtocol(configuration, metrics, time, rpcSynchronizer, new CachedPoolParallelExecutor(threadManager, "node-rpc-sync"), intakeEventCounter, rosterSize, this.network.getNetworkMetrics(), syncMetrics, selfId, fallenBehindMonitor, event -> this.receivedEventHandler.accept((PlatformEvent)event));
        this.protocols = List.of(HeartbeatProtocol.create(configuration, time, this.network.getNetworkMetrics()), reconnectProtocol, this.rpcProtocol);
        VersionCompareHandshake versionCompareHandshake = new VersionCompareHandshake(appVersion, !protocolConfig.tolerateMismatchedVersion());
        List<ProtocolRunnable> handshakeProtocols = List.of(versionCompareHandshake);
        this.network.initialize(threadManager, handshakeProtocols, this.protocols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovePeers(@NonNull List<PeerInfo> added, @NonNull List<PeerInfo> removed) {
        SyncGossipModular syncGossipModular = this;
        synchronized (syncGossipModular) {
            this.rpcProtocol.adjustTotalPermits(added.size() - removed.size());
            this.network.addRemovePeers(added, removed);
        }
    }

    @Override
    public void bind(@NonNull WiringModel model, @NonNull BindableInputWire<PlatformEvent, Void> eventInput, @NonNull BindableInputWire<EventWindow, Void> eventWindowInput, @NonNull StandardOutputWire<PlatformEvent> eventOutput, @NonNull BindableInputWire<NoInput, Void> startInput, @NonNull BindableInputWire<NoInput, Void> stopInput, @NonNull BindableInputWire<NoInput, Void> clearInput, @NonNull BindableInputWire<NoInput, Void> pauseGossip, @NonNull BindableInputWire<NoInput, Void> resumeGossip, @NonNull BindableInputWire<Duration, Void> systemHealthInput, @NonNull BindableInputWire<PlatformStatus, Void> platformStatusInput, @NonNull StandardOutputWire<SyncProgress> syncLagOutput) {
        startInput.bindConsumer(ignored -> {
            this.rpcProtocol.start();
            this.network.start();
        });
        stopInput.bindConsumer(ignored -> {
            this.rpcProtocol.stop();
            this.network.stop();
        });
        clearInput.bindConsumer(ignored -> this.rpcProtocol.clear());
        eventInput.bindConsumer(event -> {
            this.synchronizer.addEvent((PlatformEvent)event);
            this.rpcProtocol.addEvent((PlatformEvent)event);
        });
        eventWindowInput.bindConsumer(this.synchronizer::updateEventWindow);
        systemHealthInput.bindConsumer(this.rpcProtocol::reportUnhealthyDuration);
        platformStatusInput.bindConsumer(status -> this.protocols.forEach(protocol -> protocol.updatePlatformStatus((PlatformStatus)status)));
        pauseGossip.bindConsumer(ignored -> {
            this.rpcProtocol.pause();
            this.fallenBehindMonitor.notifySyncProtocolPaused();
        });
        resumeGossip.bindConsumer(ignored -> this.rpcProtocol.resume());
        this.receivedEventHandler = arg_0 -> eventOutput.forward(arg_0);
        this.syncProgressHandler = arg_0 -> syncLagOutput.forward(arg_0);
    }
}

