/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.node.NodeUtilities;
import org.hiero.consensus.roster.RosterEntryNotFoundException;

public record PeerInfo(@NonNull NodeId nodeId, @NonNull String hostname, int port, @NonNull X509Certificate signingCertificate) {
    @NonNull
    public String nodeName() {
        return NodeUtilities.formatNodeName((long)this.nodeId.id());
    }

    @NonNull
    public static PeerInfo find(@NonNull Collection<PeerInfo> peers, @NonNull NodeId nodeId) {
        for (PeerInfo peer : peers) {
            if (!peer.nodeId().equals((Object)nodeId)) continue;
            return peer;
        }
        throw new RosterEntryNotFoundException("No RosterEntry with nodeId: " + String.valueOf(nodeId) + " in peer list: " + String.valueOf(peers.stream().map(it -> it.nodeId).toList()));
    }
}

