/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication.states;

import java.io.IOException;
import java.io.InputStream;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationProtocols;
import org.hiero.consensus.gossip.impl.network.communication.NegotiatorBytes;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationState;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationStateWithDescription;
import org.hiero.consensus.gossip.impl.network.communication.states.ProtocolNegotiated;
import org.hiero.consensus.gossip.impl.network.communication.states.ReceivedInitiate;
import org.hiero.consensus.gossip.impl.network.communication.states.WaitForAcceptReject;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;

public class SentInitiate
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final InputStream byteInput;
    private final ProtocolNegotiated negotiated;
    private final ReceivedInitiate receivedInitiate;
    private final WaitForAcceptReject waitForAcceptReject;
    private final NegotiationState sleep;
    private int protocolInitiated = Integer.MIN_VALUE;

    public SentInitiate(NegotiationProtocols protocols, InputStream byteInput, ProtocolNegotiated negotiated, ReceivedInitiate receivedInitiate, WaitForAcceptReject waitForAcceptReject, NegotiationState sleep) {
        this.protocols = protocols;
        this.byteInput = byteInput;
        this.negotiated = negotiated;
        this.receivedInitiate = receivedInitiate;
        this.waitForAcceptReject = waitForAcceptReject;
        this.sleep = sleep;
    }

    public NegotiationState initiatedProtocol(byte protocolId) {
        this.protocolInitiated = protocolId;
        return this;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, InterruptedException, IOException {
        int b = this.byteInput.read();
        NegotiatorBytes.checkByte(b);
        NegotiationState next = this.transition(b);
        this.protocolInitiated = Integer.MIN_VALUE;
        return next;
    }

    private NegotiationState transition(int b) {
        if (b == 255) {
            this.setDescription("waiting for accept or reject from the peer");
            return this.waitForAcceptReject;
        }
        if (b == this.protocolInitiated) {
            PeerProtocol peerProtocol = this.protocols.getInitiatedProtocol();
            if (peerProtocol.acceptOnSimultaneousInitiate()) {
                this.setDescription("peer initiated the same protocol, running " + peerProtocol.getProtocolName());
                return this.negotiated.runProtocol(this.protocols.initiateAccepted());
            }
            this.setDescription("peer initiated the same protocol, the protocol will not run - " + peerProtocol.getProtocolName());
            this.protocols.initiateFailed();
            return this.sleep;
        }
        if (b < this.protocolInitiated) {
            this.protocols.initiateFailed();
            this.setDescription("peer initiated a higher priority protocol - " + b);
            return this.receivedInitiate.receivedInitiate(b);
        }
        this.setDescription("we initiated a higher priority protocol than the peer - " + this.protocolInitiated);
        return this.waitForAcceptReject;
    }
}

