/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.Hedera;
import com.hedera.node.app.hints.impl.HintsLibraryImpl;
import com.hedera.node.app.hints.impl.HintsServiceImpl;
import com.hedera.node.app.history.impl.HistoryLibraryImpl;
import com.hedera.node.app.history.impl.HistoryServiceImpl;
import com.hedera.node.app.info.DiskStartupNetworks;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.services.OrderedServiceMigrator;
import com.hedera.node.app.services.ServicesRegistryImpl;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.app.tss.TssBlockHashSigner;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBinImpl;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SystemEnvironmentConfigSource;
import com.swirlds.config.extensions.sources.SystemPropertiesConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.CommandLineArgs;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.builder.PlatformBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import com.swirlds.platform.config.legacy.ConfigurationException;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.signed.HashedReservedSignedState;
import com.swirlds.platform.state.signed.StartupStateUtils;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.merkle.VirtualMapStateImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.time.InstantSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterStateUtils;
import org.hiero.consensus.state.signed.ReservedSignedState;

public class ServicesMain {
    private static final Logger logger = LogManager.getLogger(ServicesMain.class);
    private static Hedera hedera;
    private static Metrics metrics;

    public static void main(String ... args) throws Exception {
        List rosterEntries;
        RosterHistory rosterHistory;
        StaticPlatformBuilder.initLogging();
        BootstrapUtils.setupConstructableRegistry();
        CommandLineArgs commandLineArgs = CommandLineArgs.parse((String[])args);
        if (commandLineArgs.localNodesToStart().size() > 1) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Multiple nodes were supplied via the command line. Only one node can be started per java process.");
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NODE_ID_NOT_PROVIDED);
            throw new ConfigurationException();
        }
        Configuration platformConfig = ServicesMain.buildPlatformConfig();
        NodeId selfId = (NodeId)commandLineArgs.localNodesToStart().stream().findFirst().orElseThrow(() -> {
            String msg = "No node id specified on command line. Use -local <nodeId>";
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NODE_ID_NOT_PROVIDED, (String)"No node id specified on command line. Use -local <nodeId>");
            return new ConfigurationException("No node id specified on command line. Use -local <nodeId>");
        });
        StaticPlatformBuilder.setupGlobalMetrics((Configuration)platformConfig);
        Time time = Time.getCurrent();
        metrics = StaticPlatformBuilder.getMetricsProvider().createPlatformMetrics(selfId);
        hedera = ServicesMain.newHedera(platformConfig, metrics, time);
        SemanticVersion version = hedera.getSemanticVersion();
        AtomicBoolean genesisNetwork = new AtomicBoolean(false);
        logger.info("Starting node {} with version {}", (Object)selfId, (Object)version);
        FileSystemManager fileSystemManager = FileSystemManager.create((Configuration)platformConfig);
        RecycleBin recycleBin = RecycleBinImpl.create((Metrics)metrics, (Configuration)platformConfig, (ThreadManager)AdHocThreadManager.getStaticThreadManager(), (Time)time, (FileSystemManager)fileSystemManager, (NodeId)selfId);
        ConsensusStateEventHandler consensusStateEventHandler = hedera.newConsensusStateEvenHandler();
        PlatformContext platformContext = PlatformContext.create((Configuration)platformConfig, (Time)Time.getCurrent(), (Metrics)metrics, (FileSystemManager)fileSystemManager, (RecycleBin)recycleBin);
        HashedReservedSignedState reservedState = StartupStateUtils.loadInitialState((RecycleBin)recycleBin, (SemanticVersion)version, () -> {
            genesisNetwork.set(true);
            VirtualMapState genesisState = hedera.newStateRoot();
            hedera.initializeStatesApi((State)genesisState, InitTrigger.GENESIS, platformConfig);
            return genesisState;
        }, (String)"com.hedera.services.ServicesMain", (String)"123", (NodeId)selfId, (PlatformContext)platformContext, hedera.getStateLifecycleManager());
        ReservedSignedState initialState = reservedState.state();
        VirtualMapState state = initialState.get().getState();
        if (!genesisNetwork.get()) {
            hedera.initializeStatesApi((State)state, InitTrigger.RESTART, platformConfig);
        }
        hedera.setInitialStateHash(reservedState.hash());
        logger.info("Initial state hash: {}", (Object)reservedState.hash().toHex());
        if (genesisNetwork.get()) {
            Roster genesisRoster = hedera.genesisRosterOrThrow();
            rosterHistory = RosterHistory.fromGenesis((Roster)genesisRoster);
            rosterEntries = genesisRoster.rosterEntries();
        } else {
            rosterHistory = RosterStateUtils.createRosterHistory((State)state);
            ReadableRosterStore rosterStore = new ReadableStoreFactoryImpl((State)state).readableStore(ReadableRosterStore.class);
            rosterEntries = Objects.requireNonNull(rosterStore.getActiveRoster()).rosterEntries();
        }
        KeysAndCerts keysAndCerts = CryptoStatic.initNodeSecurity((Configuration)platformConfig, (NodeId)selfId, (List)rosterEntries);
        String consensusEventStreamName = genesisNetwork.get() ? ServicesMain.eventStreamLocOrThrow(hedera.startupNetworks().genesisNetworkOrThrow(platformConfig), selfId.id()) : ServicesMain.canonicalEventStreamLoc(selfId.id(), (State)state);
        PlatformBuilder platformBuilder = PlatformBuilder.create((String)"com.hedera.services.ServicesMain", (String)"123", (SemanticVersion)version, (ReservedSignedState)initialState, (ConsensusStateEventHandler)consensusStateEventHandler, (NodeId)selfId, (String)consensusEventStreamName, (RosterHistory)rosterHistory, hedera.getStateLifecycleManager()).withPlatformContext(platformContext).withConfiguration(platformConfig).withKeysAndCerts(keysAndCerts).withExecutionLayer((ExecutionLayer)hedera).withStaleEventCallback((Consumer)hedera);
        Platform platform = platformBuilder.build();
        hedera.init(platform, selfId);
        platform.start();
        hedera.run();
    }

    private static String eventStreamLocOrThrow(@NonNull Network network, long nodeId) {
        return network.nodeMetadata().stream().map(NodeMetadata::nodeOrThrow).filter(node -> node.nodeId() == nodeId).map(node -> ServicesMain.canonicalEventStreamLoc(node.accountIdOrThrow())).findFirst().orElseThrow();
    }

    private static String canonicalEventStreamLoc(long nodeId, @NonNull State root) {
        try {
            ReadableNodeStoreImpl nodeStore = new ReadableNodeStoreImpl(root.getReadableStates("AddressBookService"), (ReadableEntityCounters)new ReadableEntityIdStoreImpl(root.getReadableStates("EntityIdService")));
            AccountID accountId = Objects.requireNonNull(nodeStore.get(nodeId)).accountIdOrThrow();
            return ServicesMain.canonicalEventStreamLoc(accountId);
        }
        catch (Exception ignore) {
            Network genesisNetwork = ServicesMain.hederaOrThrow().genesisNetworkSupplierOrThrow().get();
            return ServicesMain.eventStreamLocOrThrow(genesisNetwork, nodeId);
        }
    }

    private static String canonicalEventStreamLoc(@NonNull AccountID accountId) {
        Objects.requireNonNull(accountId);
        return accountId.shardNum() + "." + accountId.realmNum() + "." + accountId.accountNumOrThrow();
    }

    public static Hedera newHedera(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(metrics);
        Objects.requireNonNull(time);
        return new Hedera(ConstructableRegistry.getInstance(), ServicesRegistryImpl::new, new OrderedServiceMigrator(), InstantSource.system(), DiskStartupNetworks::new, (appContext, bootstrapConfig) -> new HintsServiceImpl(metrics, ForkJoinPool.commonPool(), appContext, new HintsLibraryImpl(), ((BlockStreamConfig)bootstrapConfig.getConfigData(BlockStreamConfig.class)).blockPeriod()), (appContext, bootstrapConfig) -> new HistoryServiceImpl(metrics, ForkJoinPool.commonPool(), appContext, new HistoryLibraryImpl()), TssBlockHashSigner::new, configuration, metrics, time, () -> new VirtualMapStateImpl(configuration, metrics));
    }

    @NonNull
    public static Configuration buildPlatformConfig() {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilder.create().withSource((ConfigSource)SystemEnvironmentConfigSource.getInstance()).withSource((ConfigSource)SystemPropertiesConfigSource.getInstance());
        FileUtils.rethrowIO(() -> BootstrapUtils.setupConfigBuilder((ConfigurationBuilder)configurationBuilder, (Path)FileUtils.getAbsolutePath((String)"settings.txt"), (Path)FileUtils.getAbsolutePath((String)"data/config/node-overrides.yaml")));
        Configuration configuration = configurationBuilder.build();
        PlatformConfigUtils.checkConfiguration((Configuration)configuration);
        return configuration;
    }

    @NonNull
    private static Hedera hederaOrThrow() {
        return Objects.requireNonNull(hedera);
    }
}

