/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeConnectionManager;
import com.hedera.node.app.blocks.impl.streaming.FileBlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.GrpcBlockItemWriter;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.util.Objects;

public class FileAndGrpcBlockItemWriter
implements BlockItemWriter {
    private final FileBlockItemWriter fileBlockItemWriter;
    private final GrpcBlockItemWriter grpcBlockItemWriter;
    private final ConfigProvider configProvider;

    public FileAndGrpcBlockItemWriter(@NonNull ConfigProvider configProvider, @NonNull SelfNodeAccountIdManager selfNodeAccountIdManager, @NonNull FileSystem fileSystem, @NonNull BlockBufferService blockBufferService, @NonNull BlockNodeConnectionManager blockNodeConnectionManager) {
        this.fileBlockItemWriter = new FileBlockItemWriter(configProvider, selfNodeAccountIdManager, fileSystem);
        this.grpcBlockItemWriter = new GrpcBlockItemWriter(blockBufferService, blockNodeConnectionManager);
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
    }

    private boolean isStreamingEnabled() {
        return ((BlockStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamToBlockNodes();
    }

    @Override
    public void openBlock(long blockNumber) {
        this.fileBlockItemWriter.openBlock(blockNumber);
        if (this.isStreamingEnabled()) {
            this.grpcBlockItemWriter.openBlock(blockNumber);
        }
    }

    @Override
    public void writePbjItemAndBytes(@NonNull BlockItem item, @NonNull Bytes bytes) {
        Objects.requireNonNull(item, "item cannot be null");
        Objects.requireNonNull(bytes, "bytes cannot be null");
        this.fileBlockItemWriter.writeItem(bytes.toByteArray());
        if (this.isStreamingEnabled()) {
            this.grpcBlockItemWriter.writePbjItem(item);
        }
    }

    @Override
    public void closeCompleteBlock() {
        this.fileBlockItemWriter.closeCompleteBlock();
        if (this.isStreamingEnabled()) {
            this.grpcBlockItemWriter.closeCompleteBlock();
        }
    }

    @Override
    public void flushPendingBlock(@NonNull PendingProof pendingProof) {
        Objects.requireNonNull(pendingProof);
        this.fileBlockItemWriter.flushPendingBlock(pendingProof);
        if (this.isStreamingEnabled()) {
            this.grpcBlockItemWriter.flushPendingBlock(pendingProof);
        }
    }

    @Override
    public void writePbjItem(@NonNull BlockItem item) {
        throw new UnsupportedOperationException("writePbjItem is not supported in this implementation");
    }

    @Override
    public void jumpToBlockAfterFreeze(long blockNumber) {
        if (this.isStreamingEnabled()) {
            this.grpcBlockItemWriter.jumpToBlockAfterFreeze(blockNumber);
        }
    }
}

