/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.handlers;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.hedera.hapi.services.auxiliary.hints.HintsPartialSignatureTransactionBody;
import com.hedera.node.app.hints.ReadableHintsStore;
import com.hedera.node.app.hints.impl.HintsContext;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HintsPartialSignatureHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(HintsPartialSignatureHandler.class);
    @NonNull
    private final ConcurrentMap<Bytes, HintsContext.Signing> signings;
    private final HintsContext hintsContext;
    private final LoadingCache<PartialSignature, Boolean> cache;

    @Inject
    public HintsPartialSignatureHandler(@NonNull Duration blockPeriod, @NonNull ConcurrentMap<Bytes, HintsContext.Signing> signings, @NonNull HintsContext context) {
        this.signings = Objects.requireNonNull(signings);
        this.hintsContext = Objects.requireNonNull(context);
        this.cache = Caffeine.newBuilder().expireAfterAccess(Math.max(1L, 2L * blockPeriod.getSeconds()), TimeUnit.SECONDS).softValues().build(this::validate);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ReadableHintsStore hintsStore = (ReadableHintsStore)context.createStore(ReadableHintsStore.class);
        Bytes crs = Objects.requireNonNull(hintsStore.crsIfKnown());
        long creatorId = context.creatorInfo().nodeId();
        try {
            HintsPartialSignatureTransactionBody op = context.body().hintsPartialSignatureOrThrow();
            PartialSignature partialSignature = new PartialSignature(this.hintsContext.constructionIdOrThrow(), crs, creatorId, op);
            TssConfig tssConfig = (TssConfig)context.configuration().getConfigData(TssConfig.class);
            if (tssConfig.useDeterministicHintsSignatures()) {
                this.cache.get((Object)partialSignature);
            } else {
                boolean isValid = this.hintsContext.validate(partialSignature.nodeId(), partialSignature.crs(), partialSignature.body());
                if (isValid) {
                    this.signings.computeIfAbsent(op.message(), b -> this.hintsContext.newSigning((Bytes)b, () -> this.signings.remove(op.message()))).incorporateValid(crs, creatorId, op.partialSignature());
                }
            }
        }
        catch (Exception e) {
            log.debug("Ignoring partial signature in pre-handle for node {}", (Object)creatorId, (Object)e);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        boolean isValid;
        Objects.requireNonNull(context);
        HintsPartialSignatureTransactionBody op = context.body().hintsPartialSignatureOrThrow();
        long creatorId = context.creatorInfo().nodeId();
        ReadableHintsStore hintsStore = (ReadableHintsStore)context.storeFactory().readableStore(ReadableHintsStore.class);
        Bytes crs = Objects.requireNonNull(hintsStore.crsIfKnown());
        TssConfig tssConfig = (TssConfig)context.configuration().getConfigData(TssConfig.class);
        if (tssConfig.useDeterministicHintsSignatures() && (isValid = Boolean.TRUE.equals(this.cache.get((Object)new PartialSignature(this.hintsContext.constructionIdOrThrow(), crs, context.creatorInfo().nodeId(), op))))) {
            this.signings.computeIfAbsent(op.message(), b -> this.hintsContext.newSigning((Bytes)b, () -> this.signings.remove(op.message()))).incorporateValid(crs, creatorId, op.partialSignature());
        }
    }

    @Nullable
    private Boolean validate(@NonNull PartialSignature partialSignature) {
        try {
            return this.hintsContext.validate(partialSignature.nodeId(), partialSignature.crs(), partialSignature.body());
        }
        catch (Exception e) {
            return null;
        }
    }

    private record PartialSignature(long constructionId, @NonNull Bytes crs, long nodeId, @NonNull HintsPartialSignatureTransactionBody body) {
        private PartialSignature {
            Objects.requireNonNull(crs);
            Objects.requireNonNull(body);
        }
    }
}

