/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.hedera.hapi.block.internal.WrappedRecordFileBlockHashes;
import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.RecordFileItem;
import com.hedera.hapi.block.stream.output.BlockHeader;
import com.hedera.hapi.node.base.BlockHashAlgorithm;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamFile;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.node.app.blocks.impl.IncrementalStreamingHasher;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.records.impl.WrappedRecordFileBlockHashesComputationInput;
import com.hedera.node.app.records.impl.WrappedRecordSidecarUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class WrappedRecordFileBlockHashesCalculator {
    private WrappedRecordFileBlockHashesCalculator() {
    }

    public static WrappedRecordFileBlockHashes compute(@NonNull WrappedRecordFileBlockHashesComputationInput in) {
        Objects.requireNonNull(in);
        if (in.recordStreamItems().isEmpty()) {
            throw new IllegalArgumentException("recordStreamItems must not be empty");
        }
        RecordStreamItem firstItem = in.recordStreamItems().getFirst();
        Timestamp firstConsensusTimestamp = Objects.requireNonNull(firstItem.record()).consensusTimestampOrThrow();
        Bytes consensusTimestampHash = BlockImplUtils.hashLeaf(Timestamp.PROTOBUF.toBytes((Object)firstConsensusTimestamp));
        WrappedRecordSidecarUtils.SidecarBundles sidecarBundles = WrappedRecordSidecarUtils.buildSidecarBundles(in.sidecarRecords(), in.maxSidecarSizeInBytes());
        RecordStreamFile recordFileContents = new RecordStreamFile(in.hapiProtoVersion(), new HashObject(HashAlgorithm.SHA_384, (int)in.startRunningHash().length(), in.startRunningHash()), new ArrayList<RecordStreamItem>(in.recordStreamItems()), new HashObject(HashAlgorithm.SHA_384, (int)in.endRunningHash().length(), in.endRunningHash()), in.blockNumber(), sidecarBundles.sidecarMetadata());
        RecordFileItem recordFileItem = RecordFileItem.newBuilder().creationTime(in.blockCreationTime()).recordFileContents(recordFileContents).sidecarFileContents(sidecarBundles.sidecarFiles()).build();
        BlockHeader.Builder header = BlockHeader.newBuilder().hapiProtoVersion(in.hapiProtoVersion()).number(in.blockNumber()).blockTimestamp(in.blockCreationTime()).hashAlgorithm(BlockHashAlgorithm.SHA2_384);
        BlockItem headerItem = BlockItem.newBuilder().blockHeader(header).build();
        BlockItem recordFileBlockItem = BlockItem.newBuilder().recordFile(recordFileItem).build();
        IncrementalStreamingHasher hasher = new IncrementalStreamingHasher(CommonUtils.sha384DigestOrThrow(), List.of(), 0L);
        hasher.addLeaf(BlockItem.PROTOBUF.toBytes((Object)headerItem).toByteArray());
        hasher.addLeaf(BlockItem.PROTOBUF.toBytes((Object)recordFileBlockItem).toByteArray());
        Bytes outputItemsTreeRootHash = Bytes.wrap((byte[])hasher.computeRootHash());
        return new WrappedRecordFileBlockHashes(in.blockNumber(), consensusTimestampHash, outputItemsTreeRootHash);
    }
}

