/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class WrappedRecordHashesIndex {
    private long lowest = -1L;
    private long highest = -1L;
    private final TreeMap<Long, Long> intervals = new TreeMap();
    private final Set<GapRange> loggedGaps = new HashSet<GapRange>(8);

    WrappedRecordHashesIndex() {
    }

    long lowestBlock() {
        return this.lowest;
    }

    long highestBlock() {
        return this.highest;
    }

    boolean hasGaps() {
        return this.intervals.size() > 1;
    }

    void reset() {
        this.lowest = -1L;
        this.highest = -1L;
        this.intervals.clear();
        this.loggedGaps.clear();
    }

    boolean contains(long blockNumber) {
        if (blockNumber < 0L) {
            return false;
        }
        Map.Entry<Long, Long> floor = this.intervals.floorEntry(blockNumber);
        return floor != null && floor.getValue() >= blockNumber;
    }

    void add(long blockNumber) {
        this.addIntervalPoint(blockNumber);
    }

    List<GapRange> addAndGetNewGaps(long blockNumber) {
        this.addIntervalPoint(blockNumber);
        List<GapRange> allGaps = this.computeGaps();
        ArrayList<GapRange> newOnes = new ArrayList<GapRange>();
        for (GapRange gap : allGaps) {
            if (!this.loggedGaps.add(gap)) continue;
            newOnes.add(gap);
        }
        return newOnes;
    }

    private void addIntervalPoint(long b) {
        if (b < 0L) {
            return;
        }
        Map.Entry<Long, Long> floor = this.intervals.floorEntry(b);
        if (floor != null && floor.getValue() >= b) {
            this.lowest = this.lowest == -1L ? floor.getKey() : Math.min(this.lowest, floor.getKey());
            this.highest = Math.max(this.highest, floor.getValue());
            return;
        }
        long start = b;
        long end = b;
        if (floor != null && floor.getValue() + 1L == b) {
            start = floor.getKey();
            this.intervals.remove(floor.getKey());
        }
        Map.Entry<Long, Long> ceiling = this.intervals.ceilingEntry(b);
        while (ceiling != null && ceiling.getKey() - 1L <= end) {
            end = Math.max(end, ceiling.getValue());
            this.intervals.remove(ceiling.getKey());
            ceiling = this.intervals.ceilingEntry(b);
        }
        this.intervals.put(start, end);
        this.lowest = this.lowest == -1L ? start : Math.min(this.lowest, start);
        this.highest = Math.max(this.highest, end);
    }

    private List<GapRange> computeGaps() {
        if (this.intervals.size() <= 1) {
            return List.of();
        }
        ArrayList<GapRange> gaps = new ArrayList<GapRange>();
        Long prevEnd = null;
        for (Map.Entry<Long, Long> e : this.intervals.entrySet()) {
            long gapEnd;
            long gapStart;
            if (prevEnd != null && (gapStart = prevEnd + 1L) <= (gapEnd = e.getKey() - 1L)) {
                gaps.add(new GapRange(gapStart, gapEnd));
            }
            prevEnd = e.getValue();
        }
        return gaps;
    }

    record GapRange(long startInclusive, long endInclusive) {
    }
}

