/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleInfo;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.ByteStringUtils;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.hederahashgraph.api.proto.java.AccountID;
import com.hederahashgraph.api.proto.java.ContractID;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.File;
import com.hederahashgraph.api.proto.java.FileID;
import com.hederahashgraph.api.proto.java.HookCall;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TokenID;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public class CommonPbjConverters {
    public static final int MAX_PBJ_RECORD_SIZE = 0x2000000;

    @NonNull
    public static Query fromPbj(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(com.hedera.hapi.node.transaction.Query.PROTOBUF, query);
            return Query.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static HookCall fromPbj(@NonNull com.hedera.hapi.node.base.HookCall hookCall) {
        Objects.requireNonNull(hookCall);
        return CommonPbjConverters.pbjToProto(hookCall, com.hedera.hapi.node.base.HookCall.class, HookCall.class);
    }

    @NonNull
    public static File fromPbj(@Nullable com.hedera.hapi.node.state.file.File file) {
        File.Builder builder = File.newBuilder();
        if (file != null) {
            builder.setFileId(CommonPbjConverters.fromPbj(file.fileIdOrThrow()));
            builder.setExpirationSecond(file.expirationSecond());
            builder.setKeys(CommonPbjConverters.pbjToProto(file.keysOrElse(KeyList.DEFAULT), KeyList.class, com.hederahashgraph.api.proto.java.KeyList.class));
            builder.setContents(ByteString.copyFrom((byte[])file.contents().toByteArray()));
            builder.setMemo(file.memo());
            builder.setDeleted(file.deleted());
        }
        return builder.build();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.EntityNumber fromPbj(@NonNull EntityNumber entityNumber) {
        Objects.requireNonNull(entityNumber);
        return com.hederahashgraph.api.proto.java.EntityNumber.newBuilder().setNumber(entityNumber.number()).build();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.TransactionBody fromPbj(@NonNull TransactionBody tx) {
        Objects.requireNonNull(tx);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(TransactionBody.PROTOBUF, tx);
            return com.hederahashgraph.api.proto.java.TransactionBody.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static List<com.hederahashgraph.api.proto.java.ServiceEndpoint> fromPbj(@NonNull List<ServiceEndpoint> endpoint) {
        Objects.requireNonNull(endpoint);
        return endpoint.stream().map(CommonPbjConverters::fromPbj).toList();
    }

    @NonNull
    public static List<ServiceEndpoint> toPbj(@NonNull List<com.hederahashgraph.api.proto.java.ServiceEndpoint> endpoint) {
        Objects.requireNonNull(endpoint);
        return endpoint.stream().map(CommonPbjConverters::toPbj).toList();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.ServiceEndpoint fromPbj(@NonNull ServiceEndpoint endpoint) {
        Objects.requireNonNull(endpoint);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(ServiceEndpoint.PROTOBUF, endpoint);
            return com.hederahashgraph.api.proto.java.ServiceEndpoint.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static Key fromPbj(@NonNull com.hedera.hapi.node.base.Key keyValue) {
        Objects.requireNonNull(keyValue);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(com.hedera.hapi.node.base.Key.PROTOBUF, keyValue);
            return Key.parseFrom((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> byte[] asBytes(@NonNull Codec<T> codec, @NonNull T tx) {
        Objects.requireNonNull(codec);
        Objects.requireNonNull(tx);
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            codec.write(tx, (WritableSequentialData)new WritableStreamingData((OutputStream)bytes));
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert from PBJ to bytes", e);
        }
    }

    @NonNull
    public static byte[] asBytes(@NonNull Bytes b) {
        byte[] buf = new byte[Math.toIntExact(b.length())];
        b.getBytes(0L, buf);
        return buf;
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.ResponseType fromPbjResponseType(@NonNull ResponseType responseType) {
        return switch (Objects.requireNonNull(responseType)) {
            default -> throw new MatchException(null, null);
            case ResponseType.UNRECOGNIZED -> throw new IllegalArgumentException("Unrecognized responseType");
            case ResponseType.ANSWER_ONLY -> com.hederahashgraph.api.proto.java.ResponseType.ANSWER_ONLY;
            case ResponseType.ANSWER_STATE_PROOF -> com.hederahashgraph.api.proto.java.ResponseType.ANSWER_STATE_PROOF;
            case ResponseType.COST_ANSWER -> com.hederahashgraph.api.proto.java.ResponseType.COST_ANSWER;
            case ResponseType.COST_ANSWER_STATE_PROOF -> com.hederahashgraph.api.proto.java.ResponseType.COST_ANSWER_STATE_PROOF;
        };
    }

    public static <T, R extends GeneratedMessage> R pbjToProto(T pbj, Class<T> pbjClass, Class<R> protoClass) {
        try {
            Field codecField = pbjClass.getDeclaredField("PROTOBUF");
            Codec codec = (Codec)codecField.get(null);
            byte[] bytes = CommonPbjConverters.asBytes(codec, pbj);
            Method protocParser = protoClass.getMethod("parseFrom", byte[].class);
            return (R)((GeneratedMessage)protocParser.invoke(null, new Object[]{bytes}));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Invalid conversion to proto for " + pbjClass.getSimpleName(), e);
        }
    }

    public static FileID fromPbj(com.hedera.hapi.node.base.FileID someFileId) {
        return FileID.newBuilder().setRealmNum(someFileId.realmNum()).setShardNum(someFileId.shardNum()).setFileNum(someFileId.fileNum()).build();
    }

    @NonNull
    public static TransactionRecord fromPbj(@NonNull com.hedera.hapi.node.transaction.TransactionRecord tx) {
        Objects.requireNonNull(tx);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(com.hedera.hapi.node.transaction.TransactionRecord.PROTOBUF, tx);
            return TransactionRecord.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static com.hederahashgraph.api.proto.java.CustomFee fromPbj(@NonNull CustomFee customFee) {
        return CommonPbjConverters.explicitPbjToProto(customFee, CustomFee.PROTOBUF, com.hederahashgraph.api.proto.java.CustomFee::parseFrom);
    }

    private static <T, R extends GeneratedMessage> R explicitPbjToProto(@NonNull T pbj, @NonNull Codec<T> pbjCodec, @NonNull ProtoParser<R> protoParser) {
        Objects.requireNonNull(pbj);
        Objects.requireNonNull(pbjCodec);
        Objects.requireNonNull(protoParser);
        try {
            return protoParser.parseFrom(CommonPbjConverters.asBytes(pbjCodec, pbj));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Serialization failure for " + String.valueOf(pbj), e);
        }
    }

    @NonNull
    public static SubType fromPbj(@NonNull com.hedera.hapi.node.base.SubType subType) {
        Objects.requireNonNull(subType);
        return SubType.valueOf((String)subType.name());
    }

    @NonNull
    public static com.hedera.hapi.node.base.TokenID toPbj(@NonNull TokenID tokenID) {
        Objects.requireNonNull(tokenID);
        return com.hedera.hapi.node.base.TokenID.newBuilder().shardNum(tokenID.getShardNum()).realmNum(tokenID.getRealmNum()).tokenNum(tokenID.getTokenNum()).build();
    }

    @NonNull
    public static ScheduleID toPbj(@NonNull com.hederahashgraph.api.proto.java.ScheduleID tokenID) {
        Objects.requireNonNull(tokenID);
        return ScheduleID.newBuilder().shardNum(tokenID.getShardNum()).realmNum(tokenID.getRealmNum()).scheduleNum(tokenID.getScheduleNum()).build();
    }

    @NonNull
    public static AccountID toPbj(@NonNull com.hederahashgraph.api.proto.java.AccountID accountID) {
        Objects.requireNonNull(accountID);
        AccountID.Builder builder = AccountID.newBuilder().shardNum(accountID.getShardNum()).realmNum(accountID.getRealmNum());
        if (accountID.getAccountCase() == AccountID.AccountCase.ALIAS) {
            builder.alias(Bytes.wrap((byte[])accountID.getAlias().toByteArray()));
        } else {
            builder.accountNum(accountID.getAccountNum());
        }
        return builder.build();
    }

    @NonNull
    public static com.hedera.hapi.node.base.ContractID toPbj(@NonNull ContractID contractID) {
        Objects.requireNonNull(contractID);
        return CommonPbjConverters.protoToPbj(contractID, com.hedera.hapi.node.base.ContractID.class);
    }

    @NonNull
    public static EntityNumber toPbj(@NonNull com.hederahashgraph.api.proto.java.EntityNumber entityNumber) {
        Objects.requireNonNull(entityNumber);
        EntityNumber.Builder builder = EntityNumber.newBuilder().number(entityNumber.getNumber());
        return builder.build();
    }

    @NonNull
    public static <T extends GeneratedMessage, R> R protoToPbj(@NonNull T proto, @NonNull Class<R> pbjClass) {
        try {
            byte[] bytes = Objects.requireNonNull(proto).toByteArray();
            Field codecField = Objects.requireNonNull(pbjClass).getDeclaredField("PROTOBUF");
            Codec codec = (Codec)codecField.get(null);
            return (R)codec.parse((ReadableSequentialData)BufferedData.wrap((byte[])bytes));
        }
        catch (ParseException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Invalid conversion to PBJ for " + pbjClass.getSimpleName(), e);
        }
    }

    @NonNull
    public static HederaFunctionality toPbj(@NonNull com.hederahashgraph.api.proto.java.HederaFunctionality function) {
        return HederaFunctionality.values()[Objects.requireNonNull(function).ordinal()];
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.HederaFunctionality fromPbj(@NonNull HederaFunctionality function) {
        return com.hederahashgraph.api.proto.java.HederaFunctionality.values()[Objects.requireNonNull(function).ordinal()];
    }

    @NonNull
    public static com.hedera.hapi.node.base.SubType toPbj(@NonNull SubType subType) {
        Objects.requireNonNull(subType);
        return switch (subType) {
            default -> throw new MatchException(null, null);
            case SubType.DEFAULT -> com.hedera.hapi.node.base.SubType.DEFAULT;
            case SubType.TOKEN_FUNGIBLE_COMMON -> com.hedera.hapi.node.base.SubType.TOKEN_FUNGIBLE_COMMON;
            case SubType.TOKEN_NON_FUNGIBLE_UNIQUE -> com.hedera.hapi.node.base.SubType.TOKEN_NON_FUNGIBLE_UNIQUE;
            case SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES -> com.hedera.hapi.node.base.SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
            case SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES -> com.hedera.hapi.node.base.SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
            case SubType.SCHEDULE_CREATE_CONTRACT_CALL -> com.hedera.hapi.node.base.SubType.SCHEDULE_CREATE_CONTRACT_CALL;
            case SubType.TOPIC_CREATE_WITH_CUSTOM_FEES -> com.hedera.hapi.node.base.SubType.TOPIC_CREATE_WITH_CUSTOM_FEES;
            case SubType.SUBMIT_MESSAGE_WITH_CUSTOM_FEES -> com.hedera.hapi.node.base.SubType.SUBMIT_MESSAGE_WITH_CUSTOM_FEES;
            case SubType.CRYPTO_TRANSFER_WITH_HOOKS -> com.hedera.hapi.node.base.SubType.CRYPTO_TRANSFER_WITH_HOOKS;
            case SubType.UNRECOGNIZED -> throw new IllegalArgumentException("Unknown subType UNRECOGNIZED");
        };
    }

    @NonNull
    public static com.hedera.hapi.node.base.ResponseCodeEnum toPbj(@NonNull ResponseCodeEnum code) {
        return com.hedera.hapi.node.base.ResponseCodeEnum.values()[Objects.requireNonNull(code).ordinal()];
    }

    @NonNull
    public static ContractID fromPbj(@NonNull com.hedera.hapi.node.base.ContractID contractID) {
        Objects.requireNonNull(contractID);
        return ContractID.newBuilder().setRealmNum(contractID.realmNum()).setShardNum(contractID.shardNum()).setContractNum(contractID.contractNumOrElse(Long.valueOf(0L)).longValue()).setEvmAddress(ByteString.copyFrom((byte[])CommonPbjConverters.asBytes(contractID.evmAddressOrElse(Bytes.EMPTY)))).build();
    }

    @NonNull
    public static ByteString fromPbj(@NonNull Bytes bytes) {
        Objects.requireNonNull(bytes);
        byte[] data = new byte[Math.toIntExact(bytes.length())];
        bytes.getBytes(0L, data);
        return ByteString.copyFrom((byte[])data);
    }

    public static Timestamp fromPbj(@NonNull com.hedera.hapi.node.base.Timestamp now) {
        Objects.requireNonNull(now);
        return Timestamp.newBuilder().setSeconds(now.seconds()).setNanos(now.nanos()).build();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.ScheduleInfo fromPbj(@NonNull ScheduleInfo pbjValue) {
        Objects.requireNonNull(pbjValue);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(ScheduleInfo.PROTOBUF, pbjValue);
            return com.hederahashgraph.api.proto.java.ScheduleInfo.parseFrom((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static Transaction fromPbj(@NonNull com.hedera.hapi.node.base.Transaction pbjValue) {
        Objects.requireNonNull(pbjValue);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(com.hedera.hapi.node.base.Transaction.PROTOBUF, pbjValue);
            return Transaction.parseFrom((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static FeeData fromPbj(@NonNull com.hedera.hapi.node.base.FeeData feeData) {
        Objects.requireNonNull(feeData);
        return FeeData.newBuilder().setNodedata(CommonPbjConverters.fromPbj(feeData.nodedataOrElse(FeeComponents.DEFAULT))).setNetworkdata(CommonPbjConverters.fromPbj(feeData.networkdataOrElse(FeeComponents.DEFAULT))).setServicedata(CommonPbjConverters.fromPbj(feeData.servicedataOrElse(FeeComponents.DEFAULT))).setSubTypeValue(feeData.subType().protoOrdinal()).build();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.FeeComponents fromPbj(@NonNull FeeComponents feeComponents) {
        Objects.requireNonNull(feeComponents);
        return com.hederahashgraph.api.proto.java.FeeComponents.newBuilder().setMin(feeComponents.min()).setMax(feeComponents.max()).setConstant(feeComponents.constant()).setBpt(feeComponents.bpt()).setVpt(feeComponents.vpt()).setRbh(feeComponents.rbh()).setSbh(feeComponents.sbh()).setGas(feeComponents.gas()).setTv(feeComponents.tv()).setBpr(feeComponents.bpr()).setSbpr(feeComponents.sbpr()).build();
    }

    public static com.hedera.hapi.node.base.FileID toPbj(FileID fileID) {
        return CommonPbjConverters.protoToPbj(fileID, com.hedera.hapi.node.base.FileID.class);
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.AccountID fromPbj(@NonNull AccountID accountID) {
        Objects.requireNonNull(accountID);
        AccountID.Builder builder = com.hederahashgraph.api.proto.java.AccountID.newBuilder().setShardNum(accountID.shardNum()).setRealmNum(accountID.realmNum());
        OneOf account = accountID.account();
        switch ((AccountID.AccountOneOfType)account.kind()) {
            case ACCOUNT_NUM: {
                builder.setAccountNum(((Long)account.as()).longValue());
                break;
            }
            case ALIAS: {
                builder.setAlias(CommonPbjConverters.fromPbj((Bytes)account.as()));
                break;
            }
            case UNSET: {
                throw new RuntimeException("Invalid account ID, no account type!");
            }
        }
        return builder.build();
    }

    @NonNull
    public static com.hedera.hapi.node.base.Key toPbj(@NonNull Key keyValue) {
        Objects.requireNonNull(keyValue);
        try {
            byte[] bytes = keyValue.toByteArray();
            return (com.hedera.hapi.node.base.Key)com.hedera.hapi.node.base.Key.PROTOBUF.parse((ReadableSequentialData)BufferedData.wrap((byte[])bytes));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static com.hedera.hapi.node.base.Timestamp toPbj(@NonNull Timestamp t) {
        Objects.requireNonNull(t);
        return com.hedera.hapi.node.base.Timestamp.newBuilder().seconds(t.getSeconds()).nanos(t.getNanos()).build();
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.ExchangeRate fromPbj(@NonNull ExchangeRate exchangeRate) {
        return com.hederahashgraph.api.proto.java.ExchangeRate.newBuilder().setCentEquiv(exchangeRate.centEquiv()).setHbarEquiv(exchangeRate.hbarEquiv()).build();
    }

    @NonNull
    public static TransactionBody toPbj(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txBody) {
        Objects.requireNonNull(txBody);
        try {
            byte[] bytes = txBody.toByteArray();
            return (TransactionBody)TransactionBody.PROTOBUF.parse((ReadableSequentialData)BufferedData.wrap((byte[])bytes), false, false, 512, 0x2000000);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static byte[] asBytes(@NonNull BufferedData b) {
        byte[] buf = new byte[Math.toIntExact(b.position())];
        b.readBytes(buf);
        return buf;
    }

    @NonNull
    public static com.hederahashgraph.api.proto.java.SchedulableTransactionBody fromPbj(@NonNull SchedulableTransactionBody tx) {
        Objects.requireNonNull(tx);
        try {
            byte[] bytes = CommonPbjConverters.asBytes(SchedulableTransactionBody.PROTOBUF, tx);
            return com.hederahashgraph.api.proto.java.SchedulableTransactionBody.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static Bytes fromByteString(ByteString contents) {
        return Bytes.wrap((byte[])ByteStringUtils.unwrapUnsafelyIfPossible(contents));
    }

    public static ServiceEndpoint toPbj(@NonNull com.hederahashgraph.api.proto.java.ServiceEndpoint t) {
        Objects.requireNonNull(t);
        return ServiceEndpoint.newBuilder().ipAddressV4(Bytes.wrap((byte[])t.getIpAddressV4().toByteArray())).port(t.getPort()).domainName(t.getDomainName()).build();
    }

    private static interface ProtoParser<R extends GeneratedMessage> {
        public R parseFrom(byte[] var1) throws InvalidProtocolBufferException;
    }
}

