/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouteBase;
import java.util.Optional;
import java.util.function.Predicate;

class HttpRouteImpl
extends HttpRouteBase
implements HttpRoute {
    private final Handler handler;
    private final Predicate<Method> methodPredicate;
    private final PathMatcher pathMatcher;
    private final Predicate<ServerRequestHeaders> headersPredicate;

    HttpRouteImpl(HttpRoute.Builder builder) {
        this.handler = builder.handler();
        this.methodPredicate = builder.methodPredicate();
        this.pathMatcher = builder.pathPredicate();
        this.headersPredicate = builder.headersPredicate();
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.MatchResult.notAccepted();
        }
        return this.pathMatcher.match(prologue.uriPath());
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue, ServerRequestHeaders headers) {
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.MatchResult.notAccepted();
        }
        if (!this.headersPredicate.test(headers)) {
            return PathMatchers.MatchResult.notAccepted();
        }
        return this.pathMatcher.match(prologue.uriPath());
    }

    @Override
    public Handler handler() {
        return this.handler;
    }

    @Override
    public Optional<PathMatcher> pathMatcher() {
        return Optional.of(this.pathMatcher);
    }

    @Override
    public void beforeStart() {
        this.handler.beforeStart();
    }

    @Override
    public void afterStart(WebServer webServer) {
        this.handler.afterStart(webServer);
    }

    @Override
    public void afterStop() {
        this.handler.afterStop();
    }

    public String toString() {
        return String.valueOf(this.methodPredicate) + " (" + String.valueOf(this.pathMatcher) + "): " + String.valueOf(this.handler);
    }
}

